set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9022953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1314',
      '22301412',
      '11002222',
      '23014223',
      '02441324',
      NULL,
      '12403414',
      '40311134',
      '04202232',
      NULL,
      '33114102',
      '24400234',
      '42134014',
      '21032310',
      '14000314',
      NULL,
      '00130323',
      '34213024',
      '33301240',
      '34440420',
      '44110104',
      '34200343',
      NULL,
      '22144343',
      NULL,
      '43200133',
      '12033202',
      '21342312',
      '43103022',
      '32310131',
      '10104010',
      '13424211',
      '33400113',
      NULL,
      NULL,
      NULL,
      '31321332',
      '01042101',
      '03441223',
      '10241040',
      '13113322',
      '33130114',
      '12010212',
      '41414331',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '2023241',
      3,
      NULL,
      NULL,
      NULL,
      '240313',
      NULL,
      NULL,
      '10-14-1996',
      79.498488,
      NULL,
      7,
      10,
      8.489895,
      5.864432,
      13.297669,
      6.393727,
      NULL,
      2.718600,
      8,
      2.496694,
      NULL,
      NULL,
      13.110514,
      5.128072,
      NULL,
      0,
      28.025385,
      2,
      24,
      NULL,
      3.138767,
      3.298244,
      NULL,
      28,
      113.843503,
      34.507839,
      41,
      42.584746,
      71,
      NULL,
      33,
      1.918814,
      16.962967,
      4.061299,
      NULL,
      NULL,
      ' 8- 2-2001',
      1.188123,
      60,
      4.671964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517494,
      0.104916,
      NULL,
      2.792632,
      1.926159,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1978',
      72,
      59,
      NULL,
      33.940458,
      51,
      41,
      60,
      NULL,
      6.327259,
      44,
      48,
      23,
      ' 1-15-1976',
      NULL,
      5.945519,
      2,
      24.460740,
      24.637546,
      3,
      3,
      ' 9-16-1997',
      5.162514,
      5,
      ' 1-24-1998',
      0,
      NULL,
      NULL,
      8,
      0.654040,
      3,
      NULL,
      NULL,
      NULL,
      10,
      10,
      1,
      0.974237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.161636,
      NULL,
      NULL,
      '10-27-1987',
      NULL,
      68,
      '10- 5-1990',
      15.865026,
      48,
      11.379240,
      85,
      ' 8-29-1990',
      39,
      0.907205,
      225,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      73,
      26,
      22.437874,
      68.804074,
      53,
      NULL,
      35,
      NULL,
      3.327696,
      16,
      2.818976,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.813141,
      2,
      58,
      3.020953,
      22,
      40.930645,
      14.696045,
      NULL,
      50.722374,
      1,
      41,
      0,
      1.523257,
      0.250966,
      2,
      0,
      0.667301,
      38,
      NULL,
      11.099829,
      3.892187,
      30.735508,
      NULL,
      0,
      0.869789,
      NULL,
      NULL,
      2.929044,
      1.796420,
      NULL,
      1.912144,
      29.486330,
      0.662025,
      13.778249,
      0,
      1,
      15.525333,
      NULL,
      NULL,
      18.374315,
      5,
      32.445541,
      NULL,
      NULL,
      8.640659,
      14,
      1,
      NULL,
      2.955520,
      2,
      0.747359,
      NULL,
      NULL,
      ' 8-26-1981',
      ' 6- 7-1985',
      ' 3- 3-1988',
      ' 0-26-1976',
      NULL,
      ' 7-21-2003',
      ' 9-11-1975',
      NULL);
commit;
end;
/


