set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '14142401',
      NULL,
      NULL,
      '14100143',
      NULL,
      '32243330',
      '01323103',
      '14143121',
      '00314111',
      NULL,
      '04021424',
      '00144413',
      '11204040',
      '01111021',
      NULL,
      '30324021',
      '44334330',
      NULL,
      '24014203',
      NULL,
      NULL,
      '20433112',
      '20321213',
      '00043410',
      NULL,
      NULL,
      '14332140',
      '42332431',
      NULL,
      '10444330',
      '30340411',
      NULL,
      '44243132',
      '23404234',
      '32323121',
      '40223430',
      '32443231',
      '00100412',
      '02014422',
      '23431411',
      '23333040',
      '22414420',
      '10210311',
      '431',
      '02',
      NULL,
      NULL,
      '0022004',
      3.984975,
      1.088433,
      1,
      NULL,
      NULL,
      4.460277,
      ' 9-18-1978',
      NULL,
      77.960140,
      NULL,
      26.251759,
      23,
      19.878069,
      NULL,
      56.367664,
      15,
      0.213915,
      8.911179,
      NULL,
      10.402261,
      22,
      NULL,
      12,
      3.919648,
      6.805226,
      2,
      17.296260,
      8.963662,
      9,
      NULL,
      97,
      NULL,
      1,
      20.706305,
      161.795207,
      50,
      86.852029,
      62.239989,
      45.577609,
      ' 5-18-1991',
      26.615275,
      NULL,
      7.161500,
      12,
      119,
      100.640666,
      NULL,
      0,
      NULL,
      NULL,
      0.169628,
      NULL,
      15,
      0,
      41,
      3,
      NULL,
      5,
      NULL,
      0.102043,
      7,
      1.363670,
      1,
      62.892843,
      0.132801,
      0,
      71.585957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      65,
      47.582905,
      NULL,
      NULL,
      0,
      ' 0-21-1998',
      1,
      NULL,
      NULL,
      3,
      0,
      63,
      0,
      1,
      13.849776,
      1,
      2,
      111.102531,
      ' 3-22-1977',
      NULL,
      16,
      NULL,
      35,
      46,
      27.657821,
      37.092524,
      51.488829,
      23.001271,
      20,
      24,
      33,
      ' 7-15-1975',
      25,
      13.734872,
      19.939899,
      60.937466,
      51,
      108.961817,
      7,
      ' 4- 9-1975',
      NULL,
      22,
      ' 2-24-1994',
      NULL,
      NULL,
      6,
      9,
      4,
      7,
      4,
      NULL,
      0.776837,
      NULL,
      NULL,
      12.683566,
      8,
      0,
      15.230256,
      1.247257,
      NULL,
      1.525473,
      '10- 1-1985',
      4,
      NULL,
      NULL,
      NULL,
      59.923203,
      119,
      ' 1- 0-1987',
      NULL,
      NULL,
      NULL,
      2.535499,
      NULL,
      NULL,
      ' 8-29-1987',
      9,
      4,
      '10-19-2001',
      8.487174,
      NULL,
      NULL,
      0.629428,
      3,
      ' 2-23-1998',
      NULL,
      0.769982,
      ' 5- 2-1985',
      3,
      NULL,
      11,
      ' 2-19-2002',
      14.493959,
      1,
      14,
      ' 0-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8);
commit;
end;
/


