set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9835448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '4',
      NULL,
      '3',
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      NULL,
      '1',
      NULL,
      '4',
      '1',
      '1',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      '0',
      '0',
      '2',
      '',
      '4',
      '',
      '4',
      '3',
      '0',
      '2',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      '4',
      '1',
      NULL,
      '41302040',
      NULL,
      NULL,
      '0012000',
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      ' 2-19-1999',
      ' 9- 9-1979',
      50,
      32,
      51.634634,
      26,
      10,
      23,
      11,
      NULL,
      11.908468,
      27.297257,
      48,
      19,
      NULL,
      5.704753,
      3.073893,
      7,
      NULL,
      NULL,
      21.858019,
      18,
      6.734126,
      1.196173,
      NULL,
      1.562171,
      1,
      98.271867,
      148,
      29,
      142.496622,
      125,
      122,
      ' 5- 7-1991',
      45,
      28.814230,
      19,
      7,
      42,
      243,
      ' 6-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      9,
      8,
      NULL,
      6,
      8,
      ' 5-11-1986',
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      49.629532,
      NULL,
      NULL,
      NULL,
      '11-25-1978',
      NULL,
      100,
      100,
      NULL,
      NULL,
      92.857040,
      54,
      7,
      NULL,
      NULL,
      6,
      NULL,
      '11- 1-1990',
      17.557139,
      7,
      16.573176,
      13,
      34,
      8.936670,
      7,
      '11-26-1985',
      28.149466,
      19,
      '10-26-1987',
      9.081663,
      0,
      13.446728,
      7.604970,
      15.175742,
      6.185813,
      0,
      5.707401,
      1.033251,
      3,
      NULL,
      2,
      1,
      23,
      6,
      1.505454,
      0,
      0,
      ' 4- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2.842813,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-1986',
      43.542622,
      ' 3-13-1988',
      10.385679,
      11,
      ' 2-18-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      19,
      ' 5- 5-1989',
      2,
      30,
      7.680094,
      ' 4- 0-2003',
      2.126339,
      19,
      NULL,
      6.762596,
      30,
      6.798651,
      26,
      ' 0-16-1977',
      NULL,
      NULL,
      69.883968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


