set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6817387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31012404',
      '41223141',
      '10124211',
      NULL,
      '03243111',
      '31301431',
      '14330313',
      '13320434',
      NULL,
      '44140433',
      NULL,
      '03404300',
      '02411310',
      NULL,
      '40430220',
      NULL,
      '33212134',
      '10444423',
      '11024424',
      '03223443',
      '42132420',
      '20441204',
      '44033021',
      '30332221',
      NULL,
      '20230313',
      NULL,
      '00241141',
      NULL,
      '10004423',
      '31111030',
      '23023002',
      '42300414',
      NULL,
      NULL,
      '02143344',
      '21133011',
      '03402211',
      '01132212',
      '24122323',
      '20342332',
      NULL,
      '11322201',
      '34013141',
      '021',
      NULL,
      NULL,
      NULL,
      '4142223',
      1.012417,
      1.459301,
      0,
      NULL,
      '033422',
      NULL,
      ' 9-16-2002',
      NULL,
      92.938513,
      NULL,
      31,
      15,
      14,
      13,
      82.269014,
      8,
      2.879302,
      0,
      NULL,
      7.725379,
      31.389575,
      NULL,
      NULL,
      3.774702,
      5,
      11,
      42,
      NULL,
      1,
      4.723879,
      25.823960,
      16,
      1.902122,
      20.831731,
      171,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.537996,
      2.478594,
      NULL,
      1.087594,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632497,
      0,
      3,
      NULL,
      1.339806,
      3.207312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-1988',
      31,
      6.487805,
      17.453447,
      23.922328,
      29,
      0,
      ' 6- 8-1999',
      0,
      1,
      210,
      NULL,
      NULL,
      29.654888,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-24-2003',
      82.335913,
      58,
      80,
      14.066213,
      95.956491,
      15,
      19,
      NULL,
      83.178429,
      74.336589,
      6,
      16,
      ' 3- 7-1994',
      1.598375,
      7,
      25.896335,
      51,
      14.162092,
      40.082884,
      8,
      ' 1-25-1980',
      6.253570,
      19,
      NULL,
      13.214487,
      16,
      10,
      20,
      2,
      8.399045,
      1.408168,
      10.780373,
      NULL,
      NULL,
      1,
      1.668233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-18-1984',
      1.977751,
      100,
      ' 6-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


