set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8836024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3440',
      '44311043',
      '32434012',
      '13110244',
      '31231330',
      '03311221',
      '23403111',
      '40341233',
      '31301303',
      '41034210',
      '31110334',
      '40201311',
      '23422143',
      NULL,
      NULL,
      '33414403',
      '24203222',
      '23021344',
      '14222131',
      '32140210',
      '10122332',
      '24021421',
      NULL,
      '03310014',
      '33330221',
      '04331333',
      '33233101',
      '11343432',
      '00041033',
      '40244440',
      '41141033',
      NULL,
      '02022314',
      '11202032',
      '01320341',
      '10203230',
      '42130122',
      '03431002',
      '42302040',
      '40121230',
      '00204144',
      NULL,
      '12403220',
      '12103332',
      '42122322',
      '',
      '',
      NULL,
      NULL,
      '4203101',
      1,
      NULL,
      2,
      NULL,
      '434123',
      0.692230,
      '10- 6-1998',
      '11- 7-1988',
      41.971697,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694659,
      36.675919,
      2.534301,
      8,
      NULL,
      32,
      8,
      32,
      5,
      15,
      5,
      0,
      3,
      17,
      15.013698,
      NULL,
      10,
      NULL,
      1.791409,
      NULL,
      22.836256,
      NULL,
      18,
      NULL,
      117,
      NULL,
      ' 8-11-1980',
      33.452972,
      28,
      18.776367,
      NULL,
      136,
      133.466396,
      ' 1-14-2001',
      0,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356897,
      1.447898,
      0.541709,
      1,
      NULL,
      1.497740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      73.293708,
      74,
      29,
      NULL,
      41,
      44.559493,
      7.310131,
      14.998367,
      57.561517,
      48.679895,
      31,
      NULL,
      30.039408,
      NULL,
      8,
      12.710639,
      75,
      NULL,
      NULL,
      ' 5-24-1991',
      10.124661,
      8,
      ' 3-11-1975',
      NULL,
      8,
      0.754133,
      10,
      15,
      5,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      0,
      4.528859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      3,
      ' 9- 4-1997',
      NULL,
      33,
      '11- 2-1993',
      7.070829,
      NULL,
      12.473736,
      29,
      ' 8- 3-1981',
      21,
      0,
      120.868934,
      ' 3-17-1980',
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      16,
      42.752086,
      42.717503,
      68.097823,
      30,
      20.353952,
      4,
      1,
      48,
      0,
      0,
      65.334208,
      NULL,
      0.880655,
      34,
      NULL,
      0,
      234.466249,
      NULL,
      3.814401,
      59,
      49,
      23.854108,
      NULL,
      1.416283,
      64.977472,
      1,
      NULL,
      0.353910,
      NULL,
      0.558391,
      1.386718,
      33,
      63,
      NULL,
      2.667326,
      24,
      35,
      1,
      NULL,
      46,
      0.660161,
      0,
      NULL,
      NULL,
      1,
      68.705905,
      4.743414,
      NULL,
      1,
      1,
      NULL,
      5,
      12.553662,
      NULL,
      45.664360,
      1.251070,
      2,
      34,
      2,
      NULL,
      NULL,
      6.567410,
      1,
      0.364981,
      1.934664,
      0.287657,
      29,
      ' 8- 8-1985',
      NULL,
      '10-25-1977',
      ' 9- 6-1984',
      ' 9-14-1981',
      '10- 3-1975',
      ' 0-23-1999',
      NULL);
commit;
end;
/


