set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '30232322',
      '02003400',
      '14021041',
      '03231110',
      '30301330',
      '42332020',
      '13011431',
      NULL,
      NULL,
      NULL,
      '32331234',
      '20322422',
      '13333112',
      '23404410',
      '34142213',
      '01303311',
      '01431003',
      '23133100',
      '32011014',
      '01044121',
      '32201232',
      '12003420',
      '00213203',
      '12314331',
      '32401420',
      '03214120',
      NULL,
      NULL,
      NULL,
      '03100120',
      '34103040',
      '24310044',
      '30132402',
      NULL,
      '04244321',
      '34210330',
      '40011301',
      NULL,
      NULL,
      '32204010',
      '32401101',
      NULL,
      '43103041',
      '23011142',
      '',
      '',
      NULL,
      NULL,
      '4231140',
      1,
      0.668679,
      2,
      NULL,
      '331444',
      1.812778,
      ' 8-11-1988',
      ' 9- 9-1985',
      41.538561,
      NULL,
      NULL,
      2.709752,
      31.224765,
      0.833143,
      45,
      NULL,
      18.308659,
      0.812456,
      NULL,
      3,
      6.298511,
      6.986912,
      NULL,
      15.694140,
      6.341114,
      NULL,
      38,
      8.570196,
      19.119980,
      1,
      NULL,
      NULL,
      NULL,
      49.331051,
      NULL,
      45.875486,
      119.773453,
      18.024597,
      1,
      ' 6-27-1980',
      NULL,
      7,
      13.087969,
      4,
      67.029740,
      166,
      ' 1-16-2000',
      0.694835,
      1.222057,
      3.074086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013645,
      1,
      1,
      0.250789,
      NULL,
      0.710103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 5-1976',
      108,
      94,
      120,
      60.286810,
      21.717430,
      80,
      10.920373,
      142,
      0.969621,
      111.324298,
      121.216560,
      62,
      ' 8-27-1976',
      19.684343,
      3,
      15.568685,
      31.336772,
      2.702585,
      33,
      11,
      ' 0-24-1983',
      16.781873,
      19,
      ' 9- 5-1976',
      NULL,
      6.050151,
      11,
      11.904666,
      18.434461,
      0.161668,
      NULL,
      13,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.094529,
      NULL,
      7,
      NULL,
      0,
      NULL,
      ' 2- 5-2002',
      NULL,
      58.507470,
      0,
      NULL,
      NULL,
      35,
      0,
      41,
      ' 7- 8-1986',
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      10,
      13.436274,
      NULL,
      133,
      39,
      5,
      2.576323,
      11,
      4,
      3,
      0.913747,
      1,
      33.271306,
      1,
      0,
      NULL,
      NULL,
      14,
      NULL,
      1,
      26.400022,
      436.975223,
      3,
      25,
      9.974660,
      0,
      30,
      0.877873,
      1,
      1,
      0.191398,
      0,
      0,
      13,
      20,
      NULL,
      NULL,
      12.044466,
      9,
      1.875473,
      1,
      23.478000,
      1.561964,
      NULL,
      NULL,
      19,
      0,
      9,
      0,
      51,
      0,
      2,
      55.061997,
      4.522738,
      0.162239,
      7,
      NULL,
      NULL,
      5,
      5.197550,
      9.410828,
      1,
      NULL,
      2,
      1.617767,
      0.316998,
      0.431746,
      NULL,
      36.714023,
      ' 9-29-1980',
      ' 5- 8-1986',
      ' 2- 4-1989',
      '11-12-1995',
      ' 5- 2-1975',
      '10-18-1984',
      NULL,
      NULL);
commit;
end;
/


