set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '40433313',
      '34010333',
      '34134100',
      NULL,
      '44030103',
      '03041304',
      '01311431',
      '44212101',
      '31300214',
      '44400401',
      '04121441',
      '24041130',
      '30134101',
      '04443412',
      '12330402',
      '44112342',
      NULL,
      '43320103',
      '13143220',
      '30021031',
      '31312403',
      '20141304',
      '34424432',
      '11131323',
      '11414130',
      '14240123',
      NULL,
      '40444111',
      '41324001',
      '21144243',
      '01210420',
      '44334322',
      '02304321',
      '33212400',
      '43114000',
      '23313240',
      '42130233',
      '23440101',
      '03424133',
      '40403220',
      '40401042',
      '13434344',
      NULL,
      '',
      NULL,
      NULL,
      '3422220',
      0.467614,
      29,
      0,
      NULL,
      '213222',
      2.150891,
      ' 7-14-2000',
      NULL,
      56.201933,
      NULL,
      2.882140,
      NULL,
      30,
      14,
      36,
      4.047588,
      13.660039,
      NULL,
      5.771315,
      5.868541,
      NULL,
      15,
      10,
      11.974676,
      28.733159,
      7,
      49,
      22,
      45,
      14,
      42.418872,
      NULL,
      NULL,
      43.355051,
      7,
      NULL,
      34.586295,
      NULL,
      NULL,
      ' 4-25-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.590516,
      3.570959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611105,
      0.279186,
      1.677742,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-22-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1975',
      NULL,
      29.410215,
      101.806303,
      77,
      131,
      59.690949,
      76,
      129.952266,
      NULL,
      9,
      127,
      60.358095,
      NULL,
      21,
      4,
      5,
      39.396020,
      40,
      82,
      5.748127,
      '11-28-1988',
      0.812246,
      11.010222,
      ' 9-13-1975',
      7.264990,
      NULL,
      8.818989,
      15,
      14.773754,
      NULL,
      NULL,
      6,
      NULL,
      84,
      1,
      0,
      2.736987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.709449,
      26.533070,
      8,
      ' 0- 4-1975',
      NULL,
      NULL,
      ' 8-17-1976',
      14.255169,
      21.431834,
      19.606025,
      8.498760,
      ' 4-26-1976',
      35.867356,
      NULL,
      NULL,
      ' 8-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      41.505730,
      88.862393,
      87.265793,
      20.847619,
      NULL,
      25.848223,
      0.029259,
      13.000392,
      47.522601,
      1.141455,
      2.059297,
      37,
      1,
      0,
      37,
      0.459030,
      1,
      101.587793,
      0.828188,
      8,
      89,
      33.760576,
      31,
      50,
      NULL,
      NULL,
      0.321454,
      0.640403,
      1.410539,
      1.263076,
      0.917393,
      1.121318,
      15,
      NULL,
      25.676256,
      17,
      13.655995,
      74,
      NULL,
      2,
      23.389334,
      1,
      1,
      0.420986,
      NULL,
      1,
      95,
      0,
      32,
      0.818238,
      NULL,
      84.942375,
      27.619601,
      15.612083,
      17,
      82,
      NULL,
      24,
      22.781543,
      5,
      3,
      3,
      1.243573,
      0.623408,
      1,
      0,
      NULL,
      39.329991,
      NULL,
      ' 5- 5-1995',
      NULL,
      ' 0-15-1988',
      ' 9-11-2000',
      ' 3-13-1983',
      NULL,
      NULL);
commit;
end;
/


