set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1133',
      '12333303',
      '01331001',
      '30230411',
      '12121331',
      '01011432',
      '40231234',
      '03444220',
      '21334422',
      '33013033',
      '32311131',
      '22443343',
      NULL,
      '04110031',
      '01113431',
      '20433321',
      NULL,
      '21240313',
      NULL,
      NULL,
      '03104230',
      '41030032',
      '14203123',
      '01240214',
      '04111200',
      '12141323',
      '44403402',
      '44324310',
      '02033104',
      '40421200',
      '04321143',
      '42201434',
      '00330213',
      '11320133',
      '42133412',
      '40431204',
      '42442332',
      '14002432',
      '10242031',
      '23301340',
      '42412104',
      '14133202',
      '41044020',
      '44441024',
      '33040032',
      '133',
      '11',
      NULL,
      NULL,
      '3200023',
      2,
      76.257400,
      0,
      NULL,
      '233222',
      2,
      ' 5-16-1990',
      ' 5- 4-2003',
      28,
      NULL,
      15.661406,
      1,
      26,
      7.562106,
      77,
      18,
      4.016216,
      15,
      1.374818,
      4.282752,
      22.631755,
      16.185665,
      NULL,
      12.616844,
      7.374564,
      6,
      9.902673,
      12,
      36,
      4,
      67,
      11.924184,
      1.716797,
      12,
      145.763055,
      31.757581,
      121,
      9.248017,
      182,
      ' 6- 0-1994',
      22,
      30.268819,
      20,
      NULL,
      NULL,
      81,
      ' 5-13-1992',
      1.092845,
      0.945239,
      NULL,
      2,
      1.845978,
      0,
      4,
      1,
      0,
      1,
      1,
      2.104863,
      0.020473,
      NULL,
      0,
      1.074499,
      1,
      1.938315,
      0.323464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1982',
      24,
      1.168382,
      3,
      13.093339,
      9,
      3,
      ' 2-15-1984',
      1.668733,
      0,
      9,
      1,
      1.390633,
      0.853638,
      1.578046,
      0,
      25.387738,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1982',
      34,
      121.821108,
      NULL,
      NULL,
      75.197987,
      39,
      101.838244,
      100.116626,
      154,
      71.548003,
      127.989324,
      NULL,
      '11- 5-1999',
      9,
      19.112552,
      NULL,
      25.376286,
      19.924616,
      67,
      NULL,
      ' 8- 7-1982',
      5,
      8,
      ' 1-26-1995',
      7.178937,
      2.947323,
      NULL,
      NULL,
      23,
      7.450536,
      0,
      NULL,
      0.686618,
      38,
      NULL,
      2,
      12,
      12.750310,
      0,
      1.220679,
      1.792820,
      1.219612,
      ' 7-11-2001',
      4,
      3.875879,
      1,
      ' 3- 3-2000',
      99.256104,
      2,
      '10- 4-1981',
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      3.827302,
      ' 0-29-1997',
      13.512680,
      7.627924,
      ' 1-23-1977',
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      ' 9- 4-1990',
      NULL,
      NULL,
      NULL,
      3,
      0,
      16,
      ' 6-29-1997',
      57,
      2.499433,
      18.815879,
      ' 9-19-1983',
      0.923169,
      71,
      ' 9-11-1997',
      1.385747,
      31,
      21,
      47.780505,
      ' 2-15-1977',
      55.966135,
      1,
      98.696241,
      '11- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8);
commit;
end;
/


