set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1214',
      '33113010',
      '43433420',
      '41433004',
      '30100322',
      '10130131',
      '42140433',
      '33300233',
      '20114402',
      '44000324',
      '20123303',
      '13302212',
      '40314200',
      '33432440',
      '00123033',
      '00134013',
      '14132223',
      '03133142',
      '04020343',
      NULL,
      '40440121',
      '41420041',
      '12320303',
      NULL,
      '23003142',
      '41422114',
      '14414214',
      '24013020',
      '41330410',
      NULL,
      '43121211',
      '13202414',
      '00441012',
      '01220322',
      NULL,
      '21233241',
      '12441220',
      '42421204',
      NULL,
      '30401223',
      '41012030',
      '02342300',
      '22201301',
      '34322210',
      '01134133',
      '222',
      '33',
      3,
      2.958696,
      '3042344',
      2.621921,
      77,
      NULL,
      NULL,
      '100211',
      1,
      ' 3-26-1988',
      '11-12-1993',
      NULL,
      NULL,
      14.919286,
      8,
      NULL,
      8,
      NULL,
      20,
      16,
      7.052878,
      14,
      NULL,
      5.422505,
      NULL,
      6.418056,
      12.395864,
      8.355147,
      10,
      49,
      8,
      7,
      24.801081,
      32.241324,
      NULL,
      NULL,
      98.442848,
      142,
      87.240163,
      85.399938,
      137,
      NULL,
      ' 9-26-2001',
      35,
      8,
      0,
      12,
      143,
      NULL,
      ' 1- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      20,
      13.709528,
      17.807187,
      3.949415,
      3.940546,
      ' 3- 6-1988',
      0.582040,
      NULL,
      137,
      0.785532,
      0,
      NULL,
      1.059878,
      1,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      NULL,
      1.657733,
      43.169902,
      NULL,
      NULL,
      39.500472,
      29.185621,
      91,
      13.919504,
      100,
      ' 5- 4-1995',
      0.879245,
      0.822667,
      5,
      NULL,
      18.077739,
      NULL,
      6.319184,
      ' 4-25-1990',
      15.654039,
      12,
      ' 7-24-1974',
      2,
      NULL,
      5.621944,
      9,
      4.187879,
      4.751125,
      0,
      11,
      0,
      19.675119,
      1,
      0,
      0.958321,
      NULL,
      1,
      3.953816,
      1,
      3.525728,
      '11- 7-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.037707,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      ' 7-27-1978',
      3.931436,
      ' 2-17-1986',
      4.485718,
      13.188245,
      ' 4-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      ' 1- 8-2000',
      34,
      11,
      16.496279,
      ' 6-13-1997',
      0.160668,
      72.656509,
      ' 1- 9-1997',
      NULL,
      1,
      6,
      4,
      ' 8-21-1977',
      38,
      0.675492,
      15.955348,
      ' 6- 1-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


