set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      '4',
      '1',
      '0',
      '4',
      '3',
      '2',
      '0',
      '1',
      '2',
      NULL,
      '0',
      NULL,
      NULL,
      '1',
      '3',
      '0',
      NULL,
      '2',
      '',
      '4',
      '1',
      NULL,
      '4',
      '1',
      '',
      '',
      '1',
      '3',
      '0',
      '3',
      '3',
      '2',
      '0',
      '0',
      '1',
      '0',
      '1',
      '110',
      '22133313',
      61,
      19.682994,
      '0044320',
      0.309222,
      177,
      0,
      NULL,
      NULL,
      2.834220,
      ' 2-11-1998',
      ' 9- 3-1995',
      22.617502,
      NULL,
      5.508669,
      9.293002,
      14.414862,
      NULL,
      NULL,
      5.181944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      10.748707,
      1,
      3.802017,
      34.992985,
      12,
      51,
      4,
      39,
      NULL,
      0,
      48,
      85.353085,
      30.222909,
      65.899153,
      152.845357,
      144.984940,
      ' 8-16-1978',
      28,
      26.528629,
      18,
      21,
      84.370573,
      79.418687,
      ' 6-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.801038,
      10,
      16.892552,
      25,
      4.047786,
      ' 9-26-1974',
      1,
      1.254923,
      73.157291,
      1,
      2,
      NULL,
      1,
      3.275506,
      24,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1984',
      NULL,
      56,
      NULL,
      60,
      99,
      73,
      NULL,
      92.552048,
      71,
      56.093989,
      50.667914,
      13,
      ' 3-29-1975',
      23,
      7.945012,
      2,
      38,
      22.260235,
      NULL,
      6,
      ' 4-21-1993',
      0.573315,
      NULL,
      ' 0-26-1990',
      NULL,
      1.106479,
      2.999364,
      7,
      0.891920,
      5,
      0,
      12.660266,
      1,
      25.702415,
      2.475492,
      1.085133,
      11,
      1.399864,
      NULL,
      3.471559,
      NULL,
      1.587589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-21-1981',
      4.401338,
      ' 1-26-2003',
      9,
      10.441916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 4- 1-1991',
      56,
      20,
      1,
      '10- 7-1991',
      1.352765,
      140,
      ' 3-21-2002',
      NULL,
      68,
      11.216737,
      NULL,
      ' 3-13-1999',
      NULL,
      0.797056,
      57.076801,
      '11-20-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


