set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603567';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3041',
      '04241311',
      NULL,
      '43321420',
      '00441123',
      '42430044',
      '03414130',
      '43113214',
      '02121310',
      '41300104',
      NULL,
      NULL,
      '02130233',
      '03111104',
      '10204110',
      '33434334',
      '42010443',
      '42232044',
      '11223212',
      '30300130',
      '20111430',
      '02423232',
      '23113020',
      '04404130',
      '01130100',
      '40000010',
      '43323011',
      '21333343',
      NULL,
      '12322223',
      '44430343',
      '32434310',
      '11342440',
      '01024123',
      NULL,
      NULL,
      '14220443',
      '12030321',
      NULL,
      '42401234',
      '20022301',
      '11202221',
      '13034420',
      NULL,
      '33302030',
      '202',
      '13',
      NULL,
      NULL,
      '2212411',
      NULL,
      0,
      0,
      NULL,
      '141320',
      5,
      NULL,
      ' 1-19-2002',
      33.863048,
      NULL,
      NULL,
      9,
      24.988971,
      12,
      11.234607,
      0.291691,
      8,
      12,
      15,
      NULL,
      16.482937,
      14.852611,
      18,
      0.165283,
      2,
      5.148884,
      NULL,
      9,
      9,
      11,
      69.494664,
      6.724904,
      0,
      NULL,
      64.111818,
      36.920758,
      32,
      53,
      NULL,
      ' 3-24-1980',
      54,
      18.089826,
      15.485248,
      15.043019,
      126.369956,
      147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      26.546125,
      18.290380,
      19,
      NULL,
      0,
      ' 2- 3-1985',
      1.410441,
      1,
      27,
      0,
      0.921647,
      61.567848,
      1,
      NULL,
      52.242209,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1975',
      60.267532,
      0,
      68.657114,
      31.856399,
      53,
      74.761863,
      NULL,
      57,
      47.533471,
      86.700206,
      9.601040,
      12.077203,
      NULL,
      11,
      1.374512,
      15,
      36,
      3,
      4,
      4.673624,
      ' 0- 7-1982',
      13,
      4,
      ' 6- 1-2003',
      4,
      NULL,
      2.442606,
      23.534049,
      23,
      8.308424,
      1.510185,
      NULL,
      0,
      NULL,
      0.416922,
      4,
      NULL,
      NULL,
      1.740499,
      1.448005,
      NULL,
      3.391673,
      '11-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      79.053867,
      11.242510,
      NULL,
      NULL,
      NULL,
      NULL,
      9.817235,
      NULL,
      NULL,
      '10-12-1981',
      13,
      5,
      ' 0-15-1988',
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      16,
      ' 9-26-1990',
      43,
      NULL,
      18,
      ' 1-17-1985',
      NULL,
      189,
      ' 5- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


