set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9764067';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '2',
      '4',
      '3',
      '1',
      '4',
      '2',
      '3',
      '0',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '4',
      '1',
      '1',
      '3',
      NULL,
      '3',
      '1',
      '3',
      '4',
      '',
      '1',
      '',
      NULL,
      '0',
      '2',
      '1',
      '3',
      '',
      NULL,
      '1',
      '1',
      NULL,
      '1',
      NULL,
      '0',
      '0',
      NULL,
      '2',
      '4',
      '1',
      '114',
      '24411421',
      NULL,
      15.670204,
      '0031301',
      0,
      1,
      3,
      NULL,
      '233231',
      4,
      ' 3-28-1976',
      ' 5-18-1984',
      13.325467,
      2.464297,
      30.325258,
      22.856203,
      12.048224,
      12.573339,
      102.788191,
      8.259739,
      21,
      0,
      12.285589,
      NULL,
      NULL,
      5,
      7,
      4.768549,
      32,
      NULL,
      NULL,
      10,
      NULL,
      21.917694,
      117,
      0,
      NULL,
      NULL,
      113,
      52.400804,
      NULL,
      NULL,
      93.613565,
      ' 1- 2-1979',
      NULL,
      35,
      NULL,
      17,
      156.791115,
      29,
      '11-27-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.766761,
      13,
      3.072825,
      4.597504,
      NULL,
      NULL,
      ' 1- 7-1992',
      1.363898,
      0,
      205.846478,
      1.553862,
      1.296709,
      1.019482,
      1,
      1,
      11.145534,
      NULL,
      NULL,
      NULL,
      ' 9-17-1996',
      87.783285,
      NULL,
      50,
      6,
      32.767798,
      60,
      35.481084,
      15,
      46.181789,
      48.777982,
      19,
      NULL,
      '10- 0-1974',
      28.322090,
      29,
      17,
      74.556801,
      55,
      80.303585,
      5,
      ' 7-11-1999',
      NULL,
      18.814865,
      ' 2- 2-1994',
      12.955449,
      15,
      6.914168,
      9.646647,
      16,
      5.733080,
      NULL,
      8.398080,
      0,
      90.560869,
      1.857516,
      1,
      19.934942,
      26,
      NULL,
      0,
      0,
      NULL,
      ' 8-18-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      235,
      5,
      ' 2-10-1987',
      NULL,
      NULL,
      NULL,
      47,
      ' 6-18-2000',
      35,
      '11-20-1994',
      11.115344,
      0.713312,
      ' 4- 0-1995',
      31.837966,
      16.677440,
      ' 3-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      21.168779,
      NULL,
      8.793488,
      34.394282,
      25,
      ' 9-22-1978',
      1,
      32,
      ' 4-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


