set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9834815';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '2',
      '1',
      '4',
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3',
      '2',
      '1',
      '1',
      NULL,
      '4',
      '4',
      '0',
      '3',
      '1',
      '0',
      '3',
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      '0',
      '2',
      NULL,
      '',
      '',
      '0',
      '3',
      NULL,
      '4',
      '1',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '4',
      '030',
      '23434103',
      51.391906,
      49,
      '2202423',
      3,
      1.288224,
      0,
      NULL,
      '132244',
      2,
      ' 0-18-1975',
      ' 3- 2-1992',
      42.189673,
      88,
      0.965568,
      14.384016,
      21,
      NULL,
      45,
      NULL,
      6.666974,
      20.420439,
      NULL,
      12,
      6,
      4.414686,
      24.008208,
      17.685813,
      18.509015,
      NULL,
      16,
      4,
      18,
      3.200002,
      16.294812,
      10,
      NULL,
      53.486211,
      96.972181,
      NULL,
      NULL,
      152.993706,
      NULL,
      '10- 4-1987',
      9,
      41.910146,
      29,
      11,
      NULL,
      193,
      '11- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      51,
      11.953039,
      32.183244,
      18.210214,
      1.070308,
      ' 5- 8-1983',
      NULL,
      1,
      33,
      0.108318,
      2.817874,
      11.309013,
      0,
      NULL,
      69.001041,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      4,
      6.571844,
      52.704192,
      24.244953,
      11,
      79,
      86.638585,
      14.899159,
      61,
      27.537998,
      22.119750,
      ' 2-18-1994',
      NULL,
      19,
      6.131079,
      56.337399,
      37,
      39,
      5.500104,
      ' 6- 1-1975',
      NULL,
      NULL,
      ' 5- 2-1994',
      NULL,
      7.735713,
      16,
      9,
      10.901642,
      1,
      1.056661,
      9.561352,
      0,
      33,
      0.435269,
      NULL,
      8,
      NULL,
      1.537555,
      1,
      0,
      NULL,
      '11- 3-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      123.772264,
      14.080968,
      ' 6- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-17-2001',
      NULL,
      ' 8-16-1988',
      2.634744,
      2.437551,
      ' 1-16-2000',
      NULL,
      NULL,
      ' 8-11-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      ' 2-14-1975',
      55.678829,
      NULL,
      NULL,
      ' 5-29-2003',
      NULL,
      32.088312,
      ' 0-19-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


