set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3001',
      '03113142',
      '32043341',
      '01331123',
      '33431330',
      '00212142',
      '32122221',
      '20432303',
      NULL,
      '04034313',
      '02000113',
      '21144110',
      '10023400',
      '13434232',
      NULL,
      NULL,
      '42000410',
      '12342331',
      '23403034',
      '33141204',
      '22133343',
      '30004034',
      NULL,
      NULL,
      '20021301',
      '03214301',
      '12213134',
      '44214111',
      '03402302',
      '23213040',
      '20022422',
      '40333444',
      '00130220',
      '22024233',
      '11142013',
      '10422442',
      NULL,
      '42301344',
      '13040124',
      '01403402',
      '11341341',
      '00132031',
      '43100023',
      '11434211',
      '43402430',
      NULL,
      '',
      NULL,
      NULL,
      '0012243',
      1,
      NULL,
      2,
      NULL,
      '130043',
      2,
      ' 7- 8-1976',
      ' 8-25-1993',
      8,
      NULL,
      24.459668,
      NULL,
      21,
      7,
      NULL,
      11,
      0.657373,
      NULL,
      NULL,
      6.069644,
      8,
      7.991143,
      2,
      4,
      1.606542,
      1.018362,
      NULL,
      9,
      NULL,
      4.436242,
      31,
      4.703021,
      NULL,
      36.580637,
      104.806106,
      14.214495,
      62.695022,
      66,
      32.560326,
      ' 1- 3-1996',
      40.883564,
      7.291259,
      14.789285,
      13.433229,
      48.967671,
      170,
      NULL,
      NULL,
      NULL,
      16,
      11.831751,
      NULL,
      NULL,
      NULL,
      NULL,
      3.792989,
      0,
      3.729098,
      1,
      1,
      11.976805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      1.811604,
      NULL,
      29.452312,
      NULL,
      21.398405,
      NULL,
      10.527737,
      NULL,
      7,
      30.783797,
      ' 1- 6-2001',
      4,
      7.826588,
      1.831364,
      17,
      22,
      NULL,
      0,
      '10- 1-1990',
      NULL,
      4.802771,
      ' 5-26-2003',
      5,
      9,
      3.096934,
      NULL,
      1.633214,
      2.908727,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.159510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.019370,
      1.684644,
      2,
      ' 4-13-1996',
      NULL,
      NULL,
      NULL,
      11,
      103.386331,
      NULL,
      NULL,
      ' 0- 6-1999',
      29.333350,
      1.802872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      44,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      17,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      45,
      NULL,
      4,
      606.033069,
      NULL,
      9.134585,
      NULL,
      NULL,
      NULL,
      4.479028,
      0.742048,
      1,
      0,
      0.813959,
      1,
      NULL,
      41.986889,
      25.324709,
      0.102419,
      18,
      7,
      0,
      1.927025,
      5,
      0.087005,
      0,
      1.482581,
      1.286144,
      1,
      9.320199,
      2,
      12.377929,
      1.885365,
      0,
      NULL,
      5.834559,
      0.757417,
      4.237575,
      36,
      22,
      5.471787,
      NULL,
      0,
      NULL,
      NULL,
      9,
      4.207404,
      NULL,
      1,
      3,
      34.772413,
      NULL,
      ' 8- 2-1990',
      ' 0-10-1985',
      NULL,
      ' 4-23-1979',
      ' 7-21-2001',
      NULL,
      NULL);
commit;
end;
/


