set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5705774';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2010',
      '41104000',
      '31413341',
      '21113401',
      '34101024',
      '14122120',
      '14034221',
      '43440022',
      '14212002',
      '14004013',
      '42323021',
      '11233004',
      '22122424',
      NULL,
      '44211411',
      '01404223',
      '11421201',
      '40024421',
      '44302110',
      '41120424',
      '32424140',
      '32140124',
      NULL,
      '24001421',
      '20030240',
      '43402241',
      '11012014',
      '02114044',
      NULL,
      '02301122',
      NULL,
      '01444301',
      '30041014',
      '33402420',
      '03223143',
      NULL,
      '03324112',
      '23421221',
      '13313441',
      '44121120',
      NULL,
      '34430240',
      '04130414',
      NULL,
      '04121004',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0.111393,
      NULL,
      NULL,
      '443313',
      2.080691,
      '10-12-1979',
      NULL,
      NULL,
      NULL,
      25.250193,
      NULL,
      4.162960,
      6,
      28,
      4,
      NULL,
      4.198236,
      25.378186,
      0.665067,
      1,
      NULL,
      1,
      7.412948,
      3,
      NULL,
      28,
      1,
      26,
      14.643859,
      40,
      1,
      NULL,
      42.448308,
      46.739703,
      29.873418,
      174.528849,
      19.388187,
      6.977584,
      NULL,
      39.540413,
      12,
      33.016330,
      14.632572,
      26.226312,
      199.873942,
      ' 7- 1-1995',
      1,
      5.471122,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019507,
      1,
      4.944507,
      0,
      0.260623,
      0.644641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1980',
      83.582022,
      61,
      92,
      110,
      53.911972,
      56,
      NULL,
      52.293599,
      103,
      NULL,
      0.830619,
      51,
      NULL,
      9.846833,
      15.339128,
      26,
      55.694372,
      59.503902,
      2,
      NULL,
      ' 0-25-1992',
      21.017663,
      13,
      ' 1-14-1997',
      NULL,
      11,
      3.589692,
      5,
      11,
      6.827054,
      NULL,
      0,
      NULL,
      17,
      1.659962,
      2,
      1.660632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.899117,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0,
      23.245868,
      34.695882,
      '10- 2-1992',
      62,
      1.807180,
      NULL,
      ' 5-23-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      105.616316,
      26.092596,
      25,
      3,
      24,
      NULL,
      NULL,
      1.583600,
      0,
      95.800155,
      0.034491,
      0,
      NULL,
      1,
      0.218068,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.429476,
      NULL,
      1.341838,
      NULL,
      0.587742,
      1.111367,
      0,
      0.453547,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.228114,
      2,
      4,
      NULL,
      NULL,
      1.397196,
      15.595618,
      1.026874,
      NULL,
      1,
      NULL,
      1.307408,
      1.265504,
      NULL,
      2.133111,
      7,
      4,
      NULL,
      NULL,
      23.875810,
      NULL,
      5.359339,
      20,
      5,
      7.080135,
      NULL,
      2.821749,
      0.212418,
      NULL,
      NULL,
      ' 1-25-1982',
      ' 9- 9-1976',
      ' 2-18-1983',
      '11- 8-1998',
      '11- 5-1997',
      ' 0-23-1980',
      ' 8-19-1988',
      NULL);
commit;
end;
/


