set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7002988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1141',
      NULL,
      '43001210',
      '10341433',
      '14100344',
      '33200204',
      '12014421',
      '00240404',
      NULL,
      '14014422',
      '13411031',
      '14441142',
      '31313023',
      '10421313',
      '01400104',
      '11122020',
      NULL,
      '04004320',
      '30224402',
      '30022432',
      '43012410',
      '40404424',
      '31124122',
      NULL,
      '12220124',
      '33431223',
      '41444214',
      '41324122',
      '12232010',
      '10404014',
      '40443103',
      '00442203',
      '43100303',
      NULL,
      '02204333',
      '21410221',
      NULL,
      '31410103',
      NULL,
      NULL,
      NULL,
      '14221142',
      '23141411',
      '42114232',
      '02421204',
      '',
      NULL,
      NULL,
      NULL,
      '2314124',
      2,
      1.379325,
      0,
      NULL,
      '432310',
      0.684865,
      ' 3-11-1980',
      ' 1-25-1990',
      59,
      NULL,
      NULL,
      8,
      18,
      NULL,
      55,
      20,
      11.658969,
      15.221689,
      19.674670,
      NULL,
      23.124482,
      37.590242,
      33,
      10,
      24,
      1,
      54.328125,
      35,
      66.982275,
      NULL,
      22.234481,
      13.721839,
      NULL,
      NULL,
      80,
      NULL,
      223.487932,
      NULL,
      208.768441,
      ' 8-18-1981',
      5,
      72,
      41,
      5,
      31,
      234.442524,
      ' 2-21-1982',
      1.512622,
      3.095887,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.597213,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.219774,
      34,
      52.139722,
      65.457336,
      NULL,
      14,
      ' 8-24-1983',
      8,
      3.781646,
      '10-17-1987',
      0.335213,
      12,
      15,
      15.984636,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      18.650403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.577721,
      43.985426,
      NULL,
      0,
      124.435187,
      NULL,
      12.752314,
      9,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 3- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      0.690690,
      NULL,
      5,
      NULL,
      0.756486,
      NULL,
      16,
      NULL,
      0.169490,
      64,
      1,
      NULL,
      16,
      1.376133,
      4,
      141,
      NULL,
      16.200076,
      NULL,
      0.074710,
      NULL,
      0.987375,
      0,
      1,
      1.609114,
      NULL,
      1.943991,
      NULL,
      NULL,
      NULL,
      12.935190,
      NULL,
      NULL,
      1,
      1,
      54.971623,
      1,
      0.801069,
      0,
      8,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6.438427,
      NULL,
      33,
      12.039802,
      5.608735,
      NULL,
      NULL,
      6,
      NULL,
      0,
      7,
      1,
      3,
      NULL,
      NULL,
      1.340963,
      0,
      NULL,
      NULL,
      '10- 2-1982',
      ' 3- 2-1986',
      '11- 8-1997',
      ' 9-28-1988',
      ' 5- 6-1983',
      ' 3-11-1983',
      NULL);
commit;
end;
/


