set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0244',
      '14312222',
      NULL,
      '32100023',
      '42124341',
      '41103442',
      NULL,
      '32324132',
      NULL,
      '10022420',
      '30031034',
      '13413213',
      '20230201',
      '43311111',
      '04220134',
      '30433201',
      '30203000',
      '23014402',
      NULL,
      '02032034',
      '42210013',
      NULL,
      '44414043',
      '03003410',
      NULL,
      '01142441',
      NULL,
      '20234122',
      '23122223',
      '11312401',
      '20130302',
      '42133224',
      '40430121',
      '14442303',
      '01042111',
      '01310214',
      NULL,
      '13432243',
      '42004323',
      NULL,
      '40143344',
      '30442433',
      NULL,
      '43114022',
      NULL,
      '303',
      NULL,
      NULL,
      NULL,
      '4021421',
      2.378605,
      1,
      NULL,
      NULL,
      '213222',
      NULL,
      '11-11-1975',
      ' 8-20-1984',
      2.714156,
      NULL,
      5.893683,
      3,
      NULL,
      14,
      27,
      7.190309,
      2.690325,
      6,
      8,
      11.294241,
      23,
      3,
      5.270024,
      17,
      NULL,
      4.011771,
      49.585235,
      14.401394,
      11,
      NULL,
      63,
      14.945295,
      0.274412,
      62.360031,
      113.029854,
      54,
      136.310980,
      8.847869,
      138,
      ' 4- 6-2002',
      39.127216,
      NULL,
      9,
      NULL,
      84,
      75.109275,
      '10-12-1999',
      3.848940,
      6.068830,
      0,
      7.367399,
      1.654286,
      1,
      0.645590,
      1,
      1.256752,
      0,
      5.653072,
      NULL,
      0.515218,
      NULL,
      1.114554,
      1,
      3.683794,
      NULL,
      1.905532,
      1.410087,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.603769,
      3,
      111.902558,
      0,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      ' 2-25-1995',
      78,
      64.300627,
      3.663358,
      15.831187,
      81,
      NULL,
      52.458837,
      71.530463,
      77,
      42.777614,
      NULL,
      16.908628,
      ' 7-23-1978',
      0.212614,
      1,
      21,
      NULL,
      58.590254,
      57.225197,
      6,
      ' 3-25-1987',
      NULL,
      7.219997,
      ' 9-17-1987',
      1,
      NULL,
      0.541177,
      16.162574,
      NULL,
      3,
      1.038651,
      21.258964,
      1,
      68,
      0.100936,
      4.821933,
      5.876705,
      19,
      NULL,
      NULL,
      NULL,
      0.187046,
      ' 4-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      36.109679,
      4.099496,
      ' 9-28-1976',
      NULL,
      NULL,
      NULL,
      24,
      ' 3- 6-2001',
      NULL,
      ' 8- 6-1981',
      10.269585,
      8,
      ' 0- 7-1983',
      51.381465,
      17,
      NULL,
      13,
      11.147540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.545703,
      ' 2- 4-2003',
      NULL,
      2,
      4,
      ' 4-29-2002',
      3.656005,
      87.541931,
      ' 8-15-1996',
      11.069101,
      67.899348,
      14.414118,
      72.438309,
      ' 6-24-1993',
      NULL,
      NULL,
      181.253230,
      ' 5-19-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


