set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2203',
      NULL,
      '21103140',
      '14214312',
      '22024012',
      NULL,
      '01122233',
      '03022433',
      '22211134',
      '40433221',
      '00434142',
      NULL,
      NULL,
      NULL,
      '23224002',
      '42442420',
      '10131213',
      NULL,
      '20031432',
      NULL,
      NULL,
      NULL,
      NULL,
      '31423232',
      '34201404',
      '40010421',
      '40233430',
      '02440240',
      '33420312',
      '21412241',
      NULL,
      '00423102',
      '44230132',
      '14124124',
      '04122334',
      '00404413',
      NULL,
      '23010441',
      '10040133',
      '01034004',
      '11202311',
      NULL,
      NULL,
      NULL,
      '31401110',
      '043',
      '34',
      NULL,
      15.746655,
      '0013014',
      2,
      16.506238,
      NULL,
      NULL,
      NULL,
      0,
      '11- 6-2002',
      NULL,
      14.146995,
      NULL,
      10,
      8.152786,
      25.963601,
      17,
      61,
      NULL,
      1.848302,
      4,
      4,
      6.307796,
      NULL,
      4.684308,
      29.063847,
      4.101241,
      28,
      15.085419,
      NULL,
      NULL,
      NULL,
      15.106823,
      19,
      NULL,
      NULL,
      57.843397,
      140,
      NULL,
      151.358999,
      100.913453,
      145.069496,
      ' 0- 4-1983',
      15.294289,
      30,
      4,
      NULL,
      145,
      181,
      ' 4-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      19,
      15.533279,
      1,
      3.471835,
      ' 6-17-2001',
      1.824222,
      0,
      49,
      0.654509,
      1.479134,
      69.345345,
      0.084993,
      NULL,
      41.841121,
      NULL,
      NULL,
      NULL,
      ' 4-23-1989',
      NULL,
      51.429780,
      67,
      NULL,
      NULL,
      25.825784,
      60.255675,
      41.024415,
      1,
      NULL,
      45.214197,
      1,
      NULL,
      2,
      10,
      13,
      NULL,
      NULL,
      23.130366,
      5.398591,
      '10- 8-1995',
      NULL,
      11.127726,
      NULL,
      3,
      NULL,
      1.495076,
      2,
      2.749311,
      0.361086,
      1.690450,
      0,
      1,
      17.947749,
      1.054633,
      0.882534,
      NULL,
      12.402954,
      14.118104,
      2.253471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      164.126568,
      NULL,
      '10-23-1994',
      NULL,
      NULL,
      NULL,
      14.007390,
      ' 7- 3-1998',
      30,
      NULL,
      12,
      4,
      ' 1-29-1976',
      50.921168,
      86.237430,
      ' 2-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      9.638147,
      ' 3-20-2001',
      56.626562,
      NULL,
      16.071448,
      ' 0-25-1988',
      1,
      NULL,
      ' 7-26-1980',
      13.161893,
      110,
      21,
      NULL,
      ' 7-26-1990',
      8.383900,
      1.913658,
      136,
      ' 6-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


