set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2031',
      '14224123',
      '33420400',
      '00203341',
      '32201100',
      '13133142',
      '13413004',
      NULL,
      '43121044',
      NULL,
      '02211232',
      '04312341',
      '43244002',
      '42222400',
      NULL,
      NULL,
      '22012023',
      '23202024',
      '01012420',
      NULL,
      '10101344',
      '30112433',
      '24141340',
      '12104322',
      '00211330',
      '22414243',
      '10134312',
      '24232202',
      '22110133',
      '44101302',
      '34224303',
      '01443402',
      NULL,
      '21022322',
      '31312444',
      '23312430',
      '20301322',
      '41341413',
      '21040231',
      '44413220',
      NULL,
      '14314024',
      '14043130',
      '23131243',
      '20200214',
      '020',
      '42',
      31,
      12.496684,
      '0244324',
      NULL,
      43.224046,
      3,
      NULL,
      '333440',
      5.997946,
      ' 2-25-1989',
      NULL,
      46,
      41.895305,
      33.893857,
      17,
      13.814264,
      12.845088,
      NULL,
      15.425399,
      2.177891,
      14,
      12,
      5.089420,
      NULL,
      8,
      22,
      17.531656,
      16.991422,
      6,
      38,
      10.667359,
      16.564785,
      13,
      68.930653,
      17,
      1.727874,
      85,
      NULL,
      1,
      53,
      NULL,
      114.916505,
      ' 0-29-1979',
      10.511523,
      20,
      23,
      NULL,
      89.954271,
      7,
      ' 2-13-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.585322,
      25.324961,
      7,
      16,
      1.753997,
      ' 5- 6-1999',
      NULL,
      0.305323,
      82.899937,
      1,
      0.448651,
      NULL,
      1.518734,
      1.839964,
      32.203477,
      NULL,
      NULL,
      NULL,
      '11-10-1975',
      17.410795,
      6.859979,
      29.193905,
      69,
      NULL,
      19.585702,
      38.733443,
      90,
      89.234846,
      NULL,
      NULL,
      79.704149,
      NULL,
      5.719296,
      1.239201,
      9.365104,
      35,
      NULL,
      6.441034,
      2,
      ' 1- 7-1981',
      NULL,
      15,
      NULL,
      1,
      3.621476,
      10,
      28,
      26,
      2.360279,
      1,
      13.054719,
      1.629310,
      NULL,
      1,
      1,
      1,
      3.667027,
      1,
      1,
      0.337702,
      NULL,
      ' 1-18-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      16.007723,
      4.272816,
      '11- 2-1982',
      NULL,
      NULL,
      NULL,
      31.355722,
      ' 5- 0-1977',
      37,
      ' 2-25-1988',
      15.669054,
      8.529205,
      ' 0- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      12,
      ' 1-20-2002',
      53.692256,
      NULL,
      17,
      '11-13-1979',
      NULL,
      82,
      '11-24-1977',
      13,
      6,
      9.338242,
      60.462790,
      ' 5-27-1994',
      48.883119,
      NULL,
      103.330694,
      ' 8-16-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


