set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      '3',
      '0',
      NULL,
      '3',
      '2',
      '3',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '4',
      '3',
      '2',
      '4',
      '',
      NULL,
      '',
      '2',
      '3',
      '4',
      '2',
      '3',
      '',
      '',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '1',
      '4',
      '4',
      '4',
      '3',
      NULL,
      '004',
      '31213121',
      18,
      39.350101,
      '2234044',
      2,
      79,
      3,
      0,
      '432432',
      5,
      ' 9-23-1978',
      NULL,
      50,
      171.950576,
      14,
      5,
      NULL,
      10,
      1.468497,
      NULL,
      3.801433,
      11.180134,
      26.314441,
      6,
      23,
      13.545442,
      24.222428,
      13.578345,
      16.465009,
      14.252777,
      20,
      NULL,
      61,
      NULL,
      49.934956,
      9.418834,
      1.930482,
      73,
      8.318892,
      39,
      25,
      108,
      44.129981,
      NULL,
      38.740744,
      26.710002,
      33.429579,
      8.470262,
      NULL,
      154,
      ' 3- 6-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.253586,
      NULL,
      13.517949,
      NULL,
      5.687015,
      NULL,
      0.784434,
      0,
      NULL,
      NULL,
      NULL,
      106,
      0.553307,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.250053,
      76,
      26,
      93.826920,
      38,
      86,
      69,
      29.439206,
      39,
      47,
      86.048841,
      56.868316,
      ' 1-25-2003',
      2.276850,
      9.241014,
      12,
      NULL,
      14.469536,
      2,
      NULL,
      ' 9-11-1994',
      7.369203,
      NULL,
      ' 9-21-1984',
      0,
      0.855130,
      0.810220,
      NULL,
      8,
      1.762567,
      1.044315,
      NULL,
      NULL,
      0.451627,
      NULL,
      1.874542,
      0.674536,
      1,
      14.515198,
      2,
      1,
      0,
      ' 3- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      121.133188,
      18.911010,
      ' 2-23-1994',
      NULL,
      NULL,
      NULL,
      38.381742,
      ' 9-28-1996',
      17,
      '11-23-2000',
      4,
      0.319082,
      ' 9-18-1993',
      4,
      NULL,
      ' 1- 1-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      ' 7- 9-1976',
      19,
      19,
      22,
      ' 8- 6-1975',
      1.122652,
      7,
      '10-25-1990',
      NULL,
      26,
      NULL,
      47,
      ' 0-19-1978',
      NULL,
      0,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


