set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      '1',
      '1',
      '2',
      '2',
      NULL,
      '2',
      NULL,
      '1',
      '3',
      NULL,
      '0',
      '1',
      '0',
      '4',
      NULL,
      '2',
      '2',
      '0',
      '3',
      '2',
      '4',
      '',
      '4',
      '',
      '3',
      '1',
      NULL,
      '1',
      '0',
      '',
      '',
      '1',
      '3',
      '0',
      NULL,
      '2',
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4',
      NULL,
      '44140134',
      79.206342,
      68,
      '4411132',
      3,
      177,
      0,
      0,
      '433023',
      2,
      NULL,
      ' 2-22-1985',
      69.145302,
      315.641374,
      14.662666,
      8.953124,
      NULL,
      12.298180,
      52.895761,
      14,
      9.189161,
      NULL,
      23,
      6,
      NULL,
      5.568319,
      0,
      10,
      15,
      9.779768,
      NULL,
      2.746352,
      2,
      15.191968,
      39.427541,
      9.512962,
      NULL,
      81,
      109.763983,
      77,
      12.812830,
      114,
      63,
      ' 3-27-1984',
      NULL,
      42,
      12.770994,
      13.401271,
      87,
      NULL,
      '10-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      NULL,
      NULL,
      16,
      2,
      '11-11-1977',
      1.974183,
      NULL,
      4,
      1.877083,
      1.816918,
      104.643145,
      1.355776,
      0,
      39.072691,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      22,
      48.428034,
      79,
      1,
      1.433659,
      32.089964,
      13.915095,
      35,
      NULL,
      44.030154,
      15.867864,
      NULL,
      10.457515,
      4,
      1.711105,
      NULL,
      3.825229,
      2.403143,
      NULL,
      ' 1-27-1997',
      NULL,
      9,
      ' 8-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      227.345951,
      6.834961,
      ' 0-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1985',
      15,
      ' 0- 1-1991',
      17.415539,
      7.000780,
      ' 4-12-1985',
      0.874311,
      11.296596,
      ' 1-13-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      14.596701,
      ' 8-28-1984',
      59.630171,
      35.351114,
      33.396138,
      ' 5-25-1978',
      0,
      NULL,
      ' 0- 8-1986',
      9,
      28.561552,
      18.692616,
      67.478954,
      ' 0- 9-1987',
      7.808296,
      NULL,
      116,
      ' 5-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


