set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8622293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41003410',
      '34342032',
      NULL,
      NULL,
      '43022044',
      '42134241',
      '12243132',
      '13103403',
      '42430442',
      '20114041',
      NULL,
      NULL,
      '41220242',
      '32344031',
      '21311000',
      '40320142',
      '42230222',
      '44013213',
      NULL,
      '24002102',
      '43123302',
      '03221133',
      '30041443',
      '11013131',
      '43200232',
      '42123124',
      '23230230',
      '04232323',
      '13234321',
      NULL,
      '42211421',
      '04303334',
      '10031313',
      '12240041',
      '21324344',
      '10403402',
      NULL,
      '13213410',
      '11301430',
      '20002013',
      '23204211',
      '43423022',
      '31241404',
      '00233022',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2.312563,
      1.706004,
      1,
      NULL,
      '033203',
      0.790023,
      ' 2-24-1989',
      '11-29-1991',
      NULL,
      NULL,
      13.870735,
      0.507107,
      8,
      1,
      6.848372,
      0,
      NULL,
      NULL,
      2,
      5.428530,
      15,
      0.677210,
      NULL,
      0.420178,
      1,
      NULL,
      11,
      11,
      53,
      NULL,
      55,
      1,
      NULL,
      19,
      33,
      4,
      52,
      19,
      109,
      ' 2-11-1980',
      11.690562,
      5.974813,
      3.331616,
      16.757804,
      62,
      NULL,
      ' 1-15-1997',
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702350,
      1.264730,
      9.690593,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-20-1977',
      1,
      89.135664,
      19.474415,
      84,
      63,
      75,
      NULL,
      13,
      NULL,
      59.636823,
      49,
      88.436102,
      ' 0-17-1979',
      2,
      5,
      14.317165,
      NULL,
      56,
      9.089906,
      9.899610,
      ' 7-20-1979',
      4,
      2,
      ' 3- 2-1983',
      0,
      14.390856,
      NULL,
      19,
      9,
      7,
      NULL,
      2,
      NULL,
      28.946352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      45.301852,
      31.977355,
      '10-19-1985',
      0,
      150,
      ' 0-25-1990',
      4.525343,
      17.260451,
      10.460575,
      10.895761,
      '11-12-1995',
      42.970339,
      0,
      182.006383,
      '10-19-1996',
      NULL,
      NULL,
      NULL,
      32.950525,
      75.464209,
      NULL,
      72.114533,
      NULL,
      29.949529,
      23,
      18,
      19,
      26.987634,
      NULL,
      76,
      1,
      0.016875,
      14,
      NULL,
      NULL,
      NULL,
      1.153455,
      0.125683,
      47.420710,
      0.354145,
      7.327657,
      119,
      15,
      31.297133,
      45.204508,
      NULL,
      NULL,
      0.691424,
      0.346011,
      NULL,
      1.168160,
      NULL,
      0,
      NULL,
      20.846347,
      3,
      NULL,
      NULL,
      58.362934,
      1,
      1.238672,
      12.141911,
      1,
      4.676879,
      0,
      16,
      0.843915,
      8.369697,
      1.211618,
      77,
      0.709889,
      NULL,
      2.198869,
      24.937867,
      1,
      14,
      42.354179,
      22.941988,
      NULL,
      7,
      5,
      26.992928,
      3.033215,
      17,
      1.317493,
      1,
      NULL,
      NULL,
      77,
      NULL,
      '11-21-2001',
      ' 8- 7-1984',
      ' 1-28-1977',
      ' 4- 8-2001',
      '10-12-2002',
      ' 4-15-1985',
      NULL);
commit;
end;
/


