set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7007504';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2413',
      '01043242',
      '20103110',
      '43301141',
      '12030302',
      NULL,
      '32302022',
      NULL,
      '43100230',
      '23223140',
      NULL,
      '14104014',
      '41044340',
      '10131233',
      '34014132',
      NULL,
      '02424042',
      '20234241',
      '13124330',
      '10211303',
      '01302410',
      '03222201',
      '22444424',
      '24210343',
      '42144023',
      '22444200',
      '31423442',
      '30113201',
      '33011134',
      NULL,
      '01122414',
      '33100404',
      '30401312',
      NULL,
      '42021224',
      '20321424',
      NULL,
      NULL,
      '11403431',
      '43200223',
      '22142244',
      '43122402',
      '22220224',
      '13431441',
      '23413013',
      '',
      '',
      NULL,
      NULL,
      '4101011',
      3.400863,
      0.345695,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-10-1993',
      ' 5-29-1980',
      NULL,
      NULL,
      24.779057,
      9.973903,
      21,
      19.778235,
      3.437632,
      NULL,
      5,
      NULL,
      17,
      0.604679,
      36,
      21,
      13.941090,
      4.692969,
      NULL,
      2.224869,
      59,
      10,
      8,
      2.581071,
      21.303832,
      NULL,
      NULL,
      54,
      36.114123,
      NULL,
      163.184835,
      141,
      167.705379,
      ' 1-22-1999',
      NULL,
      49.228509,
      18.433408,
      NULL,
      16.255214,
      171.066423,
      ' 9- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.419031,
      NULL,
      NULL,
      49.587511,
      17,
      NULL,
      0,
      ' 9- 5-1976',
      3.534092,
      11,
      ' 8-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      6,
      23.383781,
      '10-23-1976',
      0,
      NULL,
      '11-12-1987',
      5.930335,
      27.211456,
      12,
      19,
      '11-24-1997',
      32.745867,
      0.341150,
      194.636270,
      ' 2-12-1988',
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      NULL,
      NULL,
      50.592955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364305,
      3.114785,
      NULL,
      1,
      0.510064,
      43.375329,
      11.504284,
      0,
      17,
      6,
      NULL,
      15,
      NULL,
      NULL,
      30,
      1,
      62.712301,
      1,
      1.804465,
      1,
      0.629033,
      1.683901,
      1,
      55.059682,
      NULL,
      52.821169,
      24.391655,
      24,
      8,
      0,
      2,
      1,
      0.505099,
      2,
      0.537003,
      3.367639,
      4,
      9.261801,
      1.756256,
      32,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      10.286648,
      24,
      NULL,
      3,
      37.978202,
      9,
      5.625735,
      1,
      NULL,
      NULL,
      0,
      0.491665,
      0.797684,
      59,
      NULL,
      ' 0- 8-1975',
      ' 6-19-1985',
      ' 2-18-1989',
      NULL,
      ' 3- 2-1992',
      NULL,
      NULL);
commit;
end;
/


