set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0002',
      '12320001',
      '01104412',
      NULL,
      '20422422',
      '21142222',
      '30223332',
      NULL,
      NULL,
      '34203401',
      NULL,
      NULL,
      '44013030',
      '01300304',
      '11300134',
      '03034202',
      '01411004',
      '34342443',
      '41230012',
      NULL,
      '41344430',
      '00112114',
      NULL,
      NULL,
      '43201400',
      '21102441',
      '32004330',
      '13200420',
      '22313430',
      '10202123',
      '03144023',
      '31244232',
      '03104013',
      '13322012',
      '31302033',
      '11130041',
      '33404214',
      '02431303',
      '00401141',
      '21040431',
      '01422401',
      NULL,
      '00004003',
      '10130040',
      '12402313',
      '411',
      '30',
      NULL,
      NULL,
      '3232021',
      0.733267,
      1,
      3,
      NULL,
      '213244',
      0,
      ' 8-24-1983',
      ' 5-27-1979',
      NULL,
      NULL,
      1,
      10.729663,
      3.020135,
      NULL,
      12.139181,
      3,
      17,
      NULL,
      7,
      NULL,
      4.225428,
      15,
      1.193766,
      5.869407,
      6,
      0.403269,
      18,
      5.238665,
      NULL,
      10,
      62,
      14,
      0.149105,
      2.322201,
      2,
      32.502830,
      123.971784,
      NULL,
      43.162875,
      ' 0-24-1986',
      NULL,
      18.573481,
      12,
      26,
      92.364254,
      NULL,
      ' 3- 8-2001',
      1.503268,
      6,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0.928202,
      3,
      1,
      1,
      0,
      1.697698,
      NULL,
      1.345611,
      1.873830,
      1.769876,
      NULL,
      1.700836,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1977',
      66,
      NULL,
      0,
      24.630913,
      NULL,
      5.581388,
      NULL,
      0.215392,
      8,
      137.178537,
      0,
      5,
      24,
      1.187589,
      1.365433,
      58,
      NULL,
      NULL,
      NULL,
      ' 1-18-1999',
      87.647967,
      19,
      52.131876,
      19,
      13,
      NULL,
      6.344025,
      40,
      81,
      93,
      13.843859,
      48.214236,
      '10-10-1980',
      NULL,
      15,
      15.649087,
      NULL,
      45,
      17,
      NULL,
      ' 5-29-2001',
      10.420734,
      10,
      '11-27-2000',
      2,
      4.544731,
      6,
      9.654457,
      14,
      6,
      3.132607,
      19.038534,
      0.829133,
      59.953407,
      0,
      0.258109,
      7,
      18.642071,
      0.885299,
      4,
      3.032285,
      0,
      ' 7- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      27.844725,
      2,
      '10-27-1974',
      NULL,
      NULL,
      NULL,
      20.857096,
      '10-26-1976',
      4,
      ' 4- 1-1989',
      0.940152,
      3,
      ' 1- 7-2001',
      39,
      7,
      ' 3-11-1974',
      12.601351,
      17,
      '10-13-1983',
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 6- 4-1979',
      36.798119,
      8,
      17,
      ' 3-10-1984',
      NULL,
      127,
      ' 2-23-1997',
      12.978575,
      18,
      8,
      96.501780,
      ' 9-17-1987',
      52.857204,
      0.632378,
      206.037872,
      ' 0-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


