set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2340',
      '21344343',
      NULL,
      '01244444',
      NULL,
      '33041441',
      '22223341',
      '10303044',
      '13022414',
      '43300242',
      '32023014',
      '43414213',
      NULL,
      '20223213',
      '03140202',
      '31222323',
      '44041133',
      '22334334',
      '11403210',
      '23222432',
      '20430442',
      '24123424',
      '31011424',
      '13412431',
      NULL,
      '01033100',
      '04020200',
      '44103321',
      '02324041',
      '23343404',
      '20130103',
      '31112010',
      '30343221',
      '32332022',
      NULL,
      '12302241',
      '32400030',
      NULL,
      '24333421',
      '13330314',
      '14404443',
      '14244431',
      '43344211',
      NULL,
      '00120000',
      NULL,
      '20',
      20,
      12.567942,
      '3043202',
      0,
      41.293860,
      2,
      NULL,
      '011044',
      1.602060,
      NULL,
      ' 2-15-1975',
      81.785989,
      56.258944,
      6,
      3.679953,
      20,
      9,
      34,
      5.945945,
      8,
      1,
      16,
      NULL,
      35.188166,
      11.624724,
      17,
      9.501594,
      11,
      5.096577,
      28.942296,
      14.269172,
      51,
      NULL,
      57.393435,
      NULL,
      0.131522,
      21.561865,
      51.138767,
      11.257867,
      55,
      132,
      90,
      '10-24-1984',
      16,
      7,
      NULL,
      NULL,
      NULL,
      87,
      ' 3- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      3.874126,
      13,
      NULL,
      NULL,
      '11-19-1989',
      0.370937,
      0,
      NULL,
      NULL,
      NULL,
      126.966637,
      0,
      3,
      45,
      NULL,
      NULL,
      NULL,
      ' 9-29-1995',
      8.170209,
      89,
      8,
      NULL,
      89,
      52,
      77.174840,
      NULL,
      76,
      NULL,
      NULL,
      NULL,
      ' 0-28-1991',
      NULL,
      5,
      1,
      62.711856,
      32.715288,
      18,
      5.801107,
      ' 4- 0-1986',
      11.812096,
      NULL,
      '11- 2-1974',
      2.951753,
      0,
      1.418538,
      10,
      20,
      2.357535,
      1,
      16,
      1,
      20.801892,
      14.774490,
      6.126989,
      NULL,
      20.044026,
      1,
      12,
      3.890291,
      0.478492,
      ' 3-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      0.719649,
      ' 0-11-1980',
      NULL,
      NULL,
      NULL,
      5.966893,
      ' 5-18-2000',
      36,
      ' 5- 6-2000',
      4,
      3.173597,
      '11-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      25.548415,
      ' 9-11-1987',
      68.390784,
      22,
      13.629168,
      '11-12-1999',
      0,
      41,
      '10-18-1989',
      NULL,
      28.908455,
      NULL,
      61,
      ' 1-23-1983',
      50,
      1.464367,
      40,
      '10-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


