set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '0',
      '1',
      '4',
      NULL,
      '3',
      '3',
      '2',
      NULL,
      '1',
      NULL,
      '1',
      '3',
      '2',
      NULL,
      '1',
      '2',
      '2',
      '0',
      '2',
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      '1',
      '4',
      '1',
      '',
      '',
      '0',
      '4',
      NULL,
      '1',
      '2',
      '0',
      '2',
      '1',
      NULL,
      '1',
      '1',
      '211',
      NULL,
      42.714822,
      24.484795,
      '3133313',
      2.634340,
      100,
      NULL,
      NULL,
      '341112',
      4,
      '11-10-1988',
      NULL,
      146.800903,
      73,
      0,
      10,
      14,
      10.511387,
      NULL,
      3.218861,
      7,
      NULL,
      NULL,
      0,
      NULL,
      7.503605,
      20,
      13,
      9.625251,
      11,
      NULL,
      16,
      31.447131,
      NULL,
      NULL,
      15.063219,
      1,
      20,
      99,
      14,
      91,
      134,
      23,
      ' 9- 6-1990',
      NULL,
      10,
      36,
      27,
      130,
      NULL,
      ' 5-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104,
      3.097881,
      NULL,
      15.765821,
      NULL,
      7,
      ' 2-29-1974',
      1.443311,
      2.770354,
      69,
      0,
      6,
      21.653854,
      3,
      1,
      38.721238,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1980',
      82,
      69.672990,
      32.025341,
      85.509992,
      57.370852,
      NULL,
      92,
      70,
      4,
      31.790931,
      87.243584,
      84.745402,
      ' 1-23-1985',
      5,
      NULL,
      5.813317,
      13,
      48.178922,
      32,
      NULL,
      NULL,
      25.916096,
      13,
      ' 2- 8-1988',
      6.566343,
      7,
      1.912610,
      17.129843,
      NULL,
      4.267174,
      0.693136,
      17,
      0,
      NULL,
      8,
      15,
      14,
      27.388403,
      0.805395,
      2.651715,
      NULL,
      NULL,
      '11-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-16-1983',
      NULL,
      ' 6-25-1986',
      10.138600,
      9,
      '10- 4-1983',
      18,
      5.604037,
      '11-20-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 8- 8-1992',
      24.472008,
      17.455494,
      10.462671,
      ' 0-15-1976',
      1.887089,
      135,
      ' 5-18-1979',
      0,
      48.383159,
      2.739797,
      74.944646,
      ' 3- 6-1984',
      50,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


