set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      '4',
      '3',
      '0',
      '1',
      NULL,
      '1',
      '0',
      '4',
      '4',
      '1',
      '3',
      '3',
      '0',
      '1',
      '1',
      '2',
      '4',
      '0',
      '3',
      '0',
      '0',
      NULL,
      '',
      '0',
      '',
      '3',
      '4',
      '1',
      '4',
      NULL,
      '',
      '',
      '2',
      '3',
      '0',
      '4',
      '1',
      '2',
      '3',
      '1',
      '4',
      '3',
      '1',
      NULL,
      '12044012',
      68.289948,
      77.656744,
      '2221122',
      0.715350,
      64,
      3,
      1,
      NULL,
      NULL,
      ' 1- 2-1996',
      '10-25-1979',
      NULL,
      NULL,
      0,
      1,
      19.339261,
      11.977212,
      2.654260,
      4,
      9,
      0.626500,
      NULL,
      10,
      7,
      10.803318,
      15,
      6.514078,
      0.739580,
      6.641912,
      NULL,
      3,
      5.751743,
      NULL,
      100.796142,
      9.177521,
      1.462597,
      NULL,
      127.245017,
      24,
      10.081337,
      81.412799,
      7.489669,
      '10-26-1995',
      0.002849,
      NULL,
      7.491771,
      10,
      NULL,
      90,
      ' 3- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85.105826,
      25.147925,
      10.049557,
      4,
      2.959019,
      NULL,
      ' 8- 1-1981',
      1.358816,
      1.310562,
      157,
      1,
      NULL,
      143,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-28-2003',
      11.881707,
      96,
      6.285012,
      NULL,
      9.992497,
      84.504695,
      34.354830,
      44,
      21.981621,
      38.216922,
      1.804116,
      NULL,
      ' 9-23-1998',
      5,
      4,
      5.707996,
      27.868965,
      3.605681,
      74.383118,
      3,
      ' 5-28-2002',
      NULL,
      15,
      ' 3- 6-1983',
      5.342394,
      NULL,
      12.091807,
      18,
      23.935723,
      2,
      1,
      12.423920,
      0.488924,
      83,
      1.435823,
      NULL,
      4,
      22.843899,
      3.122567,
      2,
      2.931891,
      0,
      ' 3-16-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      5.821309,
      ' 7-29-1985',
      NULL,
      NULL,
      NULL,
      27.923824,
      ' 1-29-2001',
      35,
      NULL,
      9,
      1,
      ' 8-22-1978',
      56,
      12,
      ' 5-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      12.927303,
      ' 6-25-1994',
      49.983618,
      6,
      0.971675,
      NULL,
      NULL,
      28.830127,
      ' 4-20-1995',
      NULL,
      21,
      1,
      23,
      ' 2- 6-1994',
      42.203162,
      0.639486,
      28.232171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


