set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5205713';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0322',
      '31421032',
      '02114212',
      '12130430',
      '11214123',
      '30020440',
      NULL,
      '23130141',
      '42440230',
      '24234300',
      NULL,
      '44100310',
      '30334044',
      '24314141',
      NULL,
      '11002141',
      '30003321',
      '10010103',
      '11040014',
      '43343331',
      '04434304',
      NULL,
      '02321111',
      NULL,
      '43301020',
      '14241044',
      NULL,
      '34014201',
      '43014303',
      '44443234',
      '22131303',
      '13221121',
      '03020130',
      NULL,
      '10313431',
      '20231300',
      '01121403',
      '14420024',
      '02140412',
      '12220000',
      NULL,
      '40420132',
      '02133241',
      '33123442',
      '43304210',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.801216,
      0.228686,
      3,
      NULL,
      NULL,
      2,
      ' 8-29-1980',
      ' 1- 6-2001',
      61.250139,
      NULL,
      NULL,
      4,
      10.025847,
      10.732903,
      30.254542,
      4.065214,
      NULL,
      6.210074,
      9.397414,
      2.310345,
      6.403955,
      1,
      NULL,
      9,
      0,
      8.578072,
      1,
      1.321781,
      NULL,
      5.117345,
      10,
      4.023494,
      NULL,
      51,
      84.160114,
      38.247278,
      137,
      73.984478,
      128.429103,
      ' 2-25-1994',
      11.654127,
      12,
      19.877877,
      NULL,
      145.947313,
      156,
      ' 4-16-1980',
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.099941,
      NULL,
      2,
      4.412321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.800782,
      NULL,
      34.560597,
      57,
      99.574099,
      50.316163,
      21.051256,
      37.320426,
      25.273333,
      14.330436,
      NULL,
      2,
      ' 1- 0-1974',
      NULL,
      6,
      3,
      1,
      NULL,
      0,
      0,
      ' 6- 0-1991',
      8,
      13,
      '10- 2-1999',
      5.175567,
      7.378247,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      NULL,
      39,
      4.643146,
      0.766722,
      7.347671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.126298,
      4.232538,
      NULL,
      ' 7-11-1991',
      0,
      615.246456,
      ' 5- 3-1989',
      1.837887,
      85,
      1.945841,
      NULL,
      ' 7-22-1985',
      31,
      NULL,
      113.208514,
      ' 0-12-1978',
      NULL,
      NULL,
      NULL,
      16,
      33.532660,
      NULL,
      23,
      30.928145,
      10.553791,
      NULL,
      22,
      40,
      24.708310,
      NULL,
      NULL,
      1,
      1,
      178.054549,
      NULL,
      NULL,
      7.778978,
      1.468847,
      3,
      126,
      2,
      2.016581,
      236.719913,
      28,
      2,
      53,
      NULL,
      12,
      1.859480,
      1,
      0.379310,
      0.277936,
      1.697417,
      0,
      35,
      28.582816,
      3.733079,
      24.215500,
      50.263837,
      5,
      0,
      0.363445,
      10.678260,
      NULL,
      2.081187,
      0,
      4.124993,
      NULL,
      57,
      NULL,
      8,
      1.503289,
      0,
      41.247915,
      3,
      1.416569,
      16.077802,
      15.895423,
      63.285381,
      NULL,
      NULL,
      1.518565,
      16,
      NULL,
      5.191744,
      0,
      1.094684,
      1,
      3.913155,
      NULL,
      ' 7-24-2001',
      NULL,
      ' 4-18-1985',
      ' 7-27-1988',
      '11- 2-2000',
      NULL,
      '11-22-1985',
      NULL);
commit;
end;
/


