set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '0',
      '3',
      '2',
      '1',
      NULL,
      '1',
      NULL,
      '4',
      '2',
      '1',
      '2',
      '1',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      '4',
      '3',
      '1',
      '2',
      '1',
      '',
      '3',
      NULL,
      NULL,
      '1',
      '2',
      '1',
      NULL,
      '',
      '',
      '2',
      '2',
      '2',
      NULL,
      NULL,
      '1',
      NULL,
      '2',
      '4',
      NULL,
      '3',
      '104',
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1.822883,
      0,
      NULL,
      '004002',
      3.225082,
      '11-15-1987',
      NULL,
      108,
      NULL,
      16.088434,
      15,
      3.617807,
      9.471158,
      NULL,
      NULL,
      7.368939,
      10.694138,
      19,
      10,
      33.569371,
      11,
      31.484664,
      1,
      33,
      21,
      NULL,
      9,
      NULL,
      3.883981,
      NULL,
      7.963038,
      0.253927,
      NULL,
      111.614030,
      50,
      107.859368,
      NULL,
      117,
      ' 6-14-1987',
      13,
      30,
      25,
      13.230102,
      27.959217,
      148,
      ' 0-12-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.604232,
      23.105158,
      9,
      21,
      3.011385,
      NULL,
      1,
      0.239216,
      120.985546,
      0,
      NULL,
      62.587566,
      0,
      0.709886,
      20.213095,
      NULL,
      NULL,
      NULL,
      '10-17-1995',
      NULL,
      40,
      44.545177,
      NULL,
      NULL,
      32.482235,
      14,
      68.055789,
      NULL,
      25,
      7,
      39.883064,
      ' 8- 8-2000',
      5.760576,
      12,
      4,
      6.024630,
      42.640681,
      22,
      2,
      ' 4-22-1988',
      19.667979,
      2.783543,
      ' 6-26-1975',
      7.358319,
      7,
      10,
      4.553312,
      NULL,
      6,
      0.014727,
      3.469356,
      3.827142,
      18,
      6.810662,
      NULL,
      20.879003,
      26.500568,
      1.488347,
      0.674918,
      0.956013,
      NULL,
      ' 8-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      185,
      8.392691,
      NULL,
      NULL,
      NULL,
      NULL,
      23.432918,
      NULL,
      2.152316,
      ' 2-15-1982',
      5.414136,
      9.009554,
      ' 8-24-1996',
      7,
      8.671375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      17,
      ' 2-20-1995',
      2.405712,
      31,
      23,
      ' 0- 4-1989',
      3.572985,
      171.487814,
      '10-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


