set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9423644';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '1',
      '1',
      '4',
      '4',
      '4',
      '0',
      '2',
      NULL,
      '2',
      '0',
      '2',
      NULL,
      '4',
      '0',
      '4',
      '2',
      '2',
      NULL,
      NULL,
      '0',
      '3',
      '0',
      '',
      '2',
      '',
      '0',
      '0',
      '4',
      '1',
      '0',
      '',
      '',
      NULL,
      NULL,
      '2',
      NULL,
      '1',
      '1',
      '1',
      '3',
      '2',
      '1',
      '4',
      '144',
      NULL,
      22,
      49.222735,
      '1330012',
      0.119069,
      0,
      0,
      0,
      '443134',
      4.221057,
      ' 2-20-1986',
      '11-16-1989',
      66,
      225,
      7,
      NULL,
      12,
      NULL,
      25,
      5.558191,
      8.914232,
      15.618196,
      2.714839,
      17,
      11.679158,
      10,
      19,
      10,
      10.057876,
      NULL,
      20.629602,
      11.144838,
      23,
      10,
      74.212662,
      17.750757,
      0.320125,
      42,
      NULL,
      28,
      55,
      44,
      131,
      ' 4-15-1986',
      38.092271,
      20.437201,
      15.263084,
      NULL,
      NULL,
      NULL,
      ' 2- 8-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71.554638,
      47.800245,
      2,
      NULL,
      8,
      0.627444,
      ' 0-25-1988',
      1.517985,
      0,
      NULL,
      0.466226,
      5,
      27,
      0.887959,
      2.771767,
      4,
      NULL,
      NULL,
      NULL,
      '10- 5-1983',
      58,
      123,
      109,
      69,
      102,
      4,
      25.502501,
      NULL,
      95,
      52.248189,
      34.001280,
      73.022080,
      NULL,
      0,
      NULL,
      4.956847,
      24,
      25,
      3,
      NULL,
      '11- 0-2001',
      11.267013,
      6.710799,
      '10- 3-1984',
      4,
      NULL,
      9,
      8,
      9.209104,
      3.617310,
      1,
      6,
      0.321975,
      28.389846,
      1,
      1.922690,
      1.848796,
      NULL,
      6.687004,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      190.058562,
      95,
      ' 8-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      ' 4- 2-1982',
      0.344110,
      6.154610,
      NULL,
      51.804076,
      86,
      ' 2- 6-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      23,
      ' 8- 5-1995',
      NULL,
      14,
      8,
      ' 7-17-1984',
      1,
      29.297002,
      ' 6-10-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


