set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8707883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3043',
      NULL,
      '04214241',
      '34222114',
      '32123214',
      '02121314',
      '13311402',
      '32213410',
      '24303002',
      '02304341',
      NULL,
      '01301103',
      '42022011',
      '34243013',
      '44144413',
      '43431402',
      NULL,
      '24314121',
      '34403112',
      NULL,
      '22331004',
      '12024013',
      '33132212',
      '20212012',
      '13300130',
      '10131322',
      '33204210',
      '13103100',
      '24414132',
      '21444114',
      '03313430',
      '41224234',
      '40111224',
      '32403022',
      '00201011',
      NULL,
      '00120320',
      '01220112',
      NULL,
      '41101122',
      '11142444',
      NULL,
      '13013401',
      '11020020',
      '24144103',
      '',
      '',
      NULL,
      NULL,
      '0014341',
      NULL,
      1,
      2,
      NULL,
      '412332',
      2,
      ' 4-11-1975',
      NULL,
      NULL,
      NULL,
      1,
      26,
      12.154580,
      8.226361,
      39,
      13,
      NULL,
      6.145508,
      52,
      6,
      18,
      18,
      22,
      0.734016,
      NULL,
      15.939432,
      0.654875,
      12.541095,
      8.037944,
      NULL,
      36.693978,
      10,
      NULL,
      65,
      194.824929,
      NULL,
      35,
      232,
      2.536748,
      ' 2-12-1976',
      NULL,
      10.608558,
      28,
      NULL,
      58.506817,
      58,
      ' 3- 0-1987',
      NULL,
      1.765584,
      NULL,
      0.493231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.678644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-27-1999',
      83,
      102.164601,
      117.487675,
      NULL,
      0.896901,
      81,
      7,
      39.574066,
      NULL,
      88,
      87,
      23.063827,
      ' 6-21-1998',
      NULL,
      27.804222,
      29,
      NULL,
      83.782335,
      191.785049,
      11,
      ' 1-16-1977',
      NULL,
      11,
      '11-21-1994',
      13,
      4.102073,
      NULL,
      15.658965,
      10.028397,
      NULL,
      NULL,
      NULL,
      NULL,
      8.639479,
      0,
      2,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.024675,
      11.565300,
      NULL,
      ' 1-25-1989',
      1.415827,
      80,
      ' 7- 9-1993',
      NULL,
      11.900863,
      12.920876,
      0,
      '10- 8-1978',
      0.417204,
      1.376243,
      101,
      ' 0- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      31.809300,
      11,
      4,
      NULL,
      6.641761,
      NULL,
      1,
      1,
      0.122275,
      1,
      NULL,
      42.910657,
      0.389058,
      1.151936,
      31.710519,
      6.052177,
      3,
      133.219578,
      NULL,
      18.620629,
      NULL,
      1.298572,
      NULL,
      0.001155,
      1.377038,
      1.430489,
      0.160588,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      14.095270,
      NULL,
      NULL,
      0.078458,
      19.916113,
      7,
      1,
      0.756958,
      1.721268,
      61,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      14,
      9.281835,
      33,
      NULL,
      NULL,
      19.290202,
      NULL,
      7.888446,
      4.337225,
      1,
      NULL,
      0.508674,
      0,
      0.671277,
      3.222066,
      NULL,
      ' 2-26-1999',
      '11-26-1990',
      ' 6- 9-1981',
      NULL,
      ' 0-15-2000',
      ' 1- 4-1984',
      ' 1-22-1991',
      NULL);
commit;
end;
/


