set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007136';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4020',
      '33242111',
      '23021132',
      NULL,
      '10120120',
      NULL,
      '40143014',
      '33441030',
      '02422424',
      '14132142',
      NULL,
      '44412021',
      NULL,
      NULL,
      NULL,
      '23240122',
      '14330200',
      NULL,
      '41443042',
      '01002221',
      NULL,
      '03432244',
      '21321002',
      '32403130',
      '02134122',
      '34013230',
      '32130340',
      NULL,
      '02234331',
      '40323410',
      '10324420',
      '34142331',
      NULL,
      '14020420',
      '10333013',
      '10401112',
      '42030130',
      '03241014',
      '20240440',
      '00122020',
      NULL,
      NULL,
      '12030032',
      '41100333',
      '33324044',
      NULL,
      '',
      NULL,
      NULL,
      '4021124',
      2,
      1,
      0,
      NULL,
      '311144',
      2,
      '11-23-1994',
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      2.945670,
      47,
      8,
      8.967948,
      1.293368,
      NULL,
      12.593815,
      NULL,
      15.300252,
      2,
      5.143721,
      29,
      NULL,
      34.857670,
      14,
      1,
      10,
      35,
      5,
      NULL,
      56.040880,
      89,
      NULL,
      NULL,
      88,
      129,
      ' 3-17-1989',
      NULL,
      9,
      15.026960,
      5.434895,
      67,
      NULL,
      ' 6- 1-1974',
      0.576549,
      5.388684,
      NULL,
      3.501516,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033513,
      1.999279,
      4,
      1.545919,
      NULL,
      0.608073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-2000',
      67,
      32.697783,
      NULL,
      56,
      106.311025,
      83,
      53.900338,
      94,
      NULL,
      18,
      91,
      78,
      NULL,
      NULL,
      4,
      5,
      42.639691,
      38.883709,
      48.150459,
      9.282939,
      '10- 3-1981',
      7.983823,
      8,
      ' 1- 9-2001',
      6.165157,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.671666,
      NULL,
      NULL,
      6,
      0.964182,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.166104,
      20.778681,
      1,
      NULL,
      0.650265,
      195.511899,
      '10-28-1998',
      4,
      NULL,
      NULL,
      21.907488,
      '11-20-1974',
      29,
      0,
      167,
      ' 6-22-1992',
      NULL,
      NULL,
      NULL,
      20.724709,
      47,
      NULL,
      80.384835,
      75,
      79.048874,
      NULL,
      0.551831,
      NULL,
      7,
      NULL,
      58.598025,
      1.429288,
      1.844703,
      1.055741,
      NULL,
      NULL,
      NULL,
      1.730094,
      1.754565,
      76.739808,
      4,
      0.766688,
      313,
      93.905625,
      NULL,
      15,
      1,
      90,
      1,
      0,
      0.650355,
      8.162177,
      3.634533,
      1,
      67,
      41.054569,
      31.933112,
      9,
      65,
      52.567490,
      1.510500,
      0,
      1,
      0.698784,
      10.836289,
      0.358634,
      3.271488,
      0,
      47.635141,
      0,
      NULL,
      1,
      0.588777,
      35,
      NULL,
      4,
      6.508392,
      6,
      NULL,
      18,
      90.401494,
      8.808838,
      NULL,
      2,
      4,
      NULL,
      0,
      0,
      1,
      53,
      ' 5-25-1996',
      ' 4-10-1992',
      ' 1- 9-1982',
      ' 0-15-1978',
      NULL,
      '10-13-1975',
      NULL,
      NULL);
commit;
end;
/


