set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007136';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4014',
      '22222411',
      '11012303',
      '42041004',
      '24442034',
      NULL,
      '32434332',
      '10413322',
      '30232434',
      '20120031',
      '12410321',
      '03423043',
      '30412442',
      '31320114',
      '44403200',
      '12430212',
      '34242244',
      '24324441',
      '04242022',
      '10010444',
      '40202040',
      '01100321',
      '14101213',
      '32103204',
      '31133243',
      '42441404',
      '20034341',
      '32140311',
      '23031441',
      '02214030',
      '00404104',
      '31433333',
      '12440120',
      '00402111',
      '02131343',
      NULL,
      NULL,
      NULL,
      NULL,
      '32014234',
      '43310123',
      '42222440',
      '03024213',
      '41014423',
      '12241210',
      '124',
      '30',
      NULL,
      2.342787,
      '4104314',
      1.727540,
      55.571158,
      1,
      NULL,
      '010120',
      0.469031,
      ' 7-21-1998',
      '11-16-1983',
      3,
      NULL,
      26.997749,
      14.461832,
      NULL,
      1,
      NULL,
      12.965240,
      0,
      2,
      4,
      NULL,
      29,
      NULL,
      13.030288,
      6.330534,
      13.272849,
      12,
      27,
      2.957567,
      19,
      NULL,
      NULL,
      0.821539,
      1,
      18.502852,
      154,
      37.346713,
      117,
      NULL,
      66.180265,
      ' 8-20-1979',
      25.625252,
      NULL,
      13,
      0,
      42.477899,
      30.469423,
      ' 1-11-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313131,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.360469,
      3.356140,
      51,
      NULL,
      NULL,
      NULL,
      '10-25-1987',
      43.475983,
      61,
      94.116023,
      35,
      55,
      53.688604,
      NULL,
      79,
      NULL,
      29.462360,
      68,
      39,
      NULL,
      7.139719,
      8,
      2,
      9.249252,
      47.179107,
      8.994116,
      2.565299,
      '11-14-1981',
      20,
      0,
      ' 4-16-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      ' 3- 9-1994',
      18,
      ' 5- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      21,
      ' 9-29-1994',
      41,
      15.265847,
      20,
      ' 5-16-1980',
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      10.883512,
      15.116048,
      ' 8- 2-1983',
      52.187363,
      1,
      112.431294,
      '11-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


