set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9419232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2410',
      '13134220',
      '12322343',
      '11224400',
      NULL,
      NULL,
      NULL,
      NULL,
      '14213312',
      '42343140',
      '00402423',
      '21343214',
      '03402024',
      '02434242',
      NULL,
      '01312400',
      NULL,
      '31110233',
      '03102442',
      NULL,
      '34341211',
      '02411311',
      NULL,
      '10010213',
      '21402430',
      '40013022',
      '42403043',
      NULL,
      '34202401',
      '01312102',
      NULL,
      '12431432',
      NULL,
      '21110201',
      '13013133',
      '40410323',
      NULL,
      NULL,
      '11243122',
      '12320214',
      '44003441',
      '22343014',
      NULL,
      '03003324',
      '02324300',
      NULL,
      '40',
      NULL,
      NULL,
      '1212211',
      2,
      0,
      1,
      NULL,
      '423202',
      4,
      ' 1-28-1985',
      ' 3-27-1992',
      42.914802,
      NULL,
      28.747806,
      NULL,
      15,
      14,
      4,
      0.970880,
      NULL,
      12,
      32,
      6.028631,
      NULL,
      6,
      1,
      NULL,
      26,
      15,
      59,
      25,
      13,
      11,
      110,
      5,
      1,
      44.696712,
      43,
      104.471678,
      120,
      NULL,
      219.915167,
      ' 2-20-1978',
      59,
      13,
      22,
      19,
      91.913113,
      17.242889,
      NULL,
      NULL,
      0,
      1.348492,
      2.582074,
      3,
      0.798624,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.668875,
      1,
      0,
      0.752554,
      1,
      0.330674,
      0.177584,
      0,
      4.124621,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1976',
      38.647604,
      12,
      12,
      2,
      1.086100,
      NULL,
      NULL,
      1.275406,
      NULL,
      55,
      1,
      0.268307,
      157,
      1,
      0,
      70,
      NULL,
      NULL,
      NULL,
      ' 6-10-1976',
      NULL,
      55,
      NULL,
      NULL,
      37.759709,
      3.764089,
      NULL,
      2,
      73,
      40,
      10,
      NULL,
      ' 0- 0-1978',
      19,
      NULL,
      5,
      78,
      NULL,
      110,
      1,
      ' 3-26-1989',
      31.477157,
      NULL,
      ' 3-17-2003',
      0.237596,
      11.459083,
      18,
      NULL,
      NULL,
      5,
      NULL,
      11,
      1.132099,
      35,
      3,
      0.423148,
      15.590084,
      27.978568,
      0.339724,
      NULL,
      2.996063,
      1.827249,
      ' 5-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.431013,
      ' 9-24-2003',
      NULL,
      NULL,
      NULL,
      42.424328,
      ' 2-15-1998',
      16,
      ' 0-10-1987',
      0,
      5,
      ' 0-10-2001',
      NULL,
      NULL,
      '11- 1-2002',
      1,
      0,
      ' 0-28-1983',
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 5-29-1976',
      32,
      24,
      39.746181,
      ' 9-15-1999',
      5.470786,
      91,
      ' 5-15-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


