set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7010603';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4113',
      '04000144',
      '10303423',
      '10101110',
      '30400001',
      '00112133',
      '40302312',
      '21444132',
      '24340044',
      '22000012',
      NULL,
      '34201310',
      '03314321',
      '31013322',
      '44412430',
      '32012334',
      '14101011',
      NULL,
      '22223341',
      '20144032',
      '40132234',
      '00344320',
      '33110014',
      '03132424',
      '31441401',
      '41123134',
      '41134042',
      '41002232',
      '33132010',
      '10310220',
      '23414214',
      '03220241',
      '32400340',
      NULL,
      '21422213',
      '32303141',
      '42000103',
      '43240303',
      '32032031',
      '04211040',
      NULL,
      '32104131',
      '22141442',
      '30224113',
      '14404133',
      '100',
      '32',
      3.071573,
      9.292193,
      '3131110',
      NULL,
      0,
      0,
      NULL,
      '343044',
      0.451382,
      '10-20-1988',
      ' 1-28-2001',
      105.942572,
      0,
      19,
      14,
      14.993190,
      9.383611,
      46,
      17,
      10.154377,
      21,
      NULL,
      NULL,
      13,
      13,
      11.269733,
      6,
      NULL,
      13.176770,
      39,
      NULL,
      11,
      8.239329,
      3,
      NULL,
      1.057205,
      75,
      44,
      14.552957,
      4,
      174.954007,
      140,
      ' 4- 8-1990',
      36.898363,
      28,
      24.786180,
      9.191087,
      NULL,
      105,
      ' 4-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.625084,
      27.071203,
      8,
      12,
      14,
      4.477898,
      ' 2-27-1976',
      0,
      1,
      NULL,
      NULL,
      NULL,
      17,
      1.035416,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      ' 3- 3-2000',
      11.590781,
      73,
      NULL,
      23.395163,
      79,
      NULL,
      6.653300,
      71,
      58.564142,
      NULL,
      74.737527,
      87.254464,
      '10- 7-1988',
      2,
      15,
      20,
      36,
      NULL,
      48,
      11,
      NULL,
      9,
      23,
      ' 3- 4-2001',
      13.399640,
      NULL,
      9,
      5.776298,
      3.102220,
      4.473977,
      1.439518,
      6,
      0,
      7.262380,
      1.897413,
      1.467482,
      6.792180,
      28.485945,
      0.873884,
      0.370015,
      0,
      0,
      ' 3-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      123,
      0.826569,
      ' 6- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      ' 4-23-2000',
      NULL,
      19.090519,
      ' 9-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      12.590094,
      '11-20-1979',
      70.748541,
      34.792560,
      22,
      NULL,
      0,
      151,
      ' 6- 8-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


