set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9892843';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '1',
      '1',
      '2',
      '3',
      '4',
      '0',
      '3',
      '1',
      '2',
      '3',
      '4',
      '3',
      '2',
      '3',
      '4',
      '0',
      '2',
      '3',
      '3',
      '1',
      NULL,
      '1',
      '',
      '0',
      '',
      '4',
      NULL,
      '2',
      '0',
      '4',
      '',
      '',
      NULL,
      '4',
      '0',
      '1',
      '2',
      '2',
      NULL,
      '4',
      '3',
      '2',
      '1',
      NULL,
      '10034333',
      65,
      19.845015,
      '2130430',
      0.930101,
      1,
      1,
      0,
      NULL,
      5,
      NULL,
      ' 9-27-1976',
      88,
      NULL,
      16,
      15,
      18,
      3.025769,
      123,
      3.935446,
      23.228978,
      27,
      46.325173,
      12.766985,
      19,
      6,
      25,
      0,
      27,
      NULL,
      45,
      4.798073,
      67.687834,
      28.760440,
      NULL,
      1,
      NULL,
      NULL,
      31,
      61.743143,
      215,
      NULL,
      1,
      ' 6-28-1982',
      62.199334,
      41.341229,
      22,
      NULL,
      193.936357,
      32,
      ' 2-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.607811,
      7.400570,
      3,
      2,
      NULL,
      8.079199,
      ' 5- 5-1983',
      0.934185,
      1.542279,
      103,
      NULL,
      2,
      137,
      3.668035,
      5.969556,
      100.002953,
      NULL,
      NULL,
      NULL,
      ' 5-19-1985',
      98.565111,
      47.707235,
      25,
      NULL,
      92.747691,
      NULL,
      7,
      NULL,
      NULL,
      105,
      NULL,
      102,
      ' 7-12-1978',
      NULL,
      18.393114,
      15.011468,
      81,
      NULL,
      6.849201,
      3,
      ' 5-12-1983',
      33.014905,
      0,
      ' 0-16-1978',
      26,
      0,
      28.545524,
      30.128310,
      NULL,
      NULL,
      14.196827,
      4,
      NULL,
      NULL,
      1.155876,
      0,
      NULL,
      NULL,
      1.026141,
      1.859369,
      0,
      1,
      ' 2- 7-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.847612,
      ' 2-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-1991',
      15.285299,
      NULL,
      15,
      NULL,
      '10-24-1988',
      NULL,
      NULL,
      ' 6-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4.918834,
      ' 9- 7-1974',
      44,
      61.237579,
      20.171616,
      ' 5-19-1990',
      NULL,
      10,
      ' 1- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


