set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9120918';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0104',
      NULL,
      '00042103',
      '41210000',
      '14042400',
      '31110100',
      '00142410',
      '03042243',
      '40403141',
      '04442213',
      '33310331',
      NULL,
      NULL,
      '10321000',
      '41404444',
      '30341241',
      '30423401',
      '30024241',
      '44040130',
      '14414030',
      '24011240',
      '02222431',
      NULL,
      '32233034',
      NULL,
      '44031314',
      '22301233',
      '24222421',
      '20324234',
      '14023021',
      NULL,
      '44042041',
      '13443414',
      '21234134',
      NULL,
      '32443140',
      '43012232',
      NULL,
      '20203242',
      NULL,
      '41423332',
      '42211334',
      NULL,
      '20334002',
      NULL,
      '401',
      '44',
      NULL,
      NULL,
      '0414023',
      0,
      NULL,
      1,
      NULL,
      '013300',
      NULL,
      ' 0- 2-1997',
      ' 2- 2-1984',
      30.470925,
      NULL,
      NULL,
      NULL,
      32.428257,
      1.085574,
      139.518118,
      10,
      33.648127,
      31,
      NULL,
      8,
      1.300097,
      NULL,
      8.959857,
      14,
      27.478448,
      17,
      38.646001,
      7,
      NULL,
      12,
      78,
      25,
      1,
      NULL,
      39.771944,
      71,
      185,
      77,
      140,
      NULL,
      NULL,
      15.038628,
      11.226886,
      NULL,
      215.118428,
      132,
      ' 4-25-1975',
      0.929285,
      2.589369,
      1.147165,
      0.049317,
      0.477578,
      0,
      NULL,
      1.895804,
      NULL,
      NULL,
      1,
      0.200537,
      0,
      1,
      0.808461,
      1.765398,
      1.170699,
      1.232423,
      1.406442,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1999',
      7,
      13.340290,
      21.135701,
      9.826476,
      2,
      1.802234,
      ' 0-22-1981',
      1.122246,
      0.200762,
      NULL,
      NULL,
      2,
      13,
      NULL,
      NULL,
      7.794447,
      0.899799,
      0,
      14,
      ' 5- 7-1985',
      NULL,
      112,
      48,
      NULL,
      17.238133,
      7,
      103,
      32.731511,
      34.386079,
      NULL,
      47.495998,
      NULL,
      NULL,
      0,
      13,
      30,
      NULL,
      97,
      31.457857,
      4.084990,
      ' 0-13-1987',
      7,
      39,
      ' 0-17-1982',
      17,
      23.573905,
      12,
      3,
      10,
      3,
      0,
      9.042183,
      0.503646,
      13,
      1.057005,
      11.273929,
      11,
      22.830007,
      1,
      1,
      3.665954,
      2.563693,
      ' 5-10-1974',
      NULL,
      3.477854,
      6,
      ' 9- 5-1979',
      NULL,
      2.823608,
      ' 0-12-1985',
      30.403536,
      5,
      ' 0-16-1986',
      23.266957,
      '11-11-1974',
      38,
      ' 0-20-1977',
      15.841487,
      5,
      NULL,
      3,
      NULL,
      ' 8-20-1977',
      17.769617,
      NULL,
      '10-18-1998',
      NULL,
      1.281663,
      '10-17-1986',
      0,
      1,
      10.077720,
      ' 7-25-1983',
      37,
      19.842876,
      18,
      ' 0-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


