set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7606963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '0',
      '0',
      '0',
      NULL,
      '0',
      '0',
      '0',
      '3',
      NULL,
      '1',
      '4',
      '3',
      '3',
      '3',
      '2',
      '2',
      '2',
      '1',
      '4',
      '0',
      '3',
      '2',
      '',
      '2',
      '',
      '4',
      '2',
      '3',
      NULL,
      '0',
      '',
      '',
      NULL,
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      NULL,
      '0',
      '0',
      '0',
      NULL,
      '200',
      '31120033',
      4.278764,
      28,
      '1403140',
      3,
      NULL,
      2,
      NULL,
      '342014',
      4.880175,
      ' 3- 9-1983',
      ' 4-28-1984',
      NULL,
      0,
      10.892239,
      8,
      0.422367,
      0.154597,
      98,
      4.436274,
      28.775567,
      21.201878,
      60.734198,
      1.690449,
      NULL,
      NULL,
      13,
      9.181988,
      3,
      10,
      30.645272,
      20,
      59.637471,
      17.797371,
      38.783227,
      21.887009,
      NULL,
      78.324408,
      173,
      20,
      NULL,
      168,
      177.629976,
      ' 8- 9-1987',
      13.874562,
      17,
      18.212320,
      4.354858,
      28,
      79,
      ' 1-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      18,
      11.639252,
      9.927347,
      4,
      NULL,
      '11-23-1990',
      0.044246,
      0.334084,
      178.071878,
      0,
      3.815530,
      135,
      1.703092,
      1,
      46.369379,
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      67,
      76,
      78,
      NULL,
      51,
      26,
      90,
      NULL,
      12.762377,
      58.535876,
      27,
      ' 4-11-1974',
      19,
      6,
      1.640564,
      57,
      9,
      1,
      8,
      NULL,
      12.280721,
      4,
      NULL,
      7,
      NULL,
      18,
      NULL,
      2.858180,
      2.294823,
      0,
      5,
      1,
      120,
      1,
      9.024457,
      11,
      18.230484,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.793941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095516,
      NULL,
      NULL,
      ' 3- 4-1996',
      11.840882,
      14.175683,
      NULL,
      75.450573,
      53.837436,
      ' 8-28-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      17.631278,
      ' 5-28-1989',
      38.840875,
      27,
      42,
      '10- 5-1997',
      0.159506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


