set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '40302110',
      '31401104',
      '30400242',
      NULL,
      '14031200',
      NULL,
      '24423143',
      '02311313',
      '21342140',
      '23333412',
      '44443220',
      NULL,
      '13313211',
      NULL,
      '24322323',
      NULL,
      '40212220',
      '40324213',
      '04121042',
      '40240221',
      '31424403',
      NULL,
      '33332243',
      '01223221',
      '31302442',
      '14403310',
      '30130221',
      '04401200',
      NULL,
      '13304200',
      '34144141',
      NULL,
      NULL,
      NULL,
      '23141302',
      '01431231',
      NULL,
      '14343330',
      '32333322',
      '01441332',
      NULL,
      '14344010',
      '42144313',
      '244',
      '14',
      40.939561,
      4,
      '1041141',
      3.007139,
      0.094351,
      1,
      NULL,
      '312140',
      2.106423,
      '10-17-1983',
      ' 2- 9-1979',
      73.637669,
      NULL,
      4.217037,
      12,
      19,
      NULL,
      38,
      5,
      31,
      11.665196,
      14.125510,
      11,
      20.409785,
      19,
      25,
      6.074229,
      2.963332,
      14,
      1.884147,
      NULL,
      NULL,
      NULL,
      76.222417,
      10,
      0,
      30.847237,
      11.901426,
      18,
      180.738781,
      193.855076,
      186.977448,
      NULL,
      22,
      32.491768,
      18,
      21,
      92,
      141.312272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.777892,
      NULL,
      5.036603,
      0,
      2,
      2,
      ' 9-18-1978',
      1,
      3.000816,
      79.636664,
      0,
      NULL,
      96,
      1.828485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1985',
      29.971914,
      61,
      74.593295,
      46,
      5.816580,
      88,
      NULL,
      18.988564,
      NULL,
      93.956773,
      31,
      78.406730,
      ' 2-16-1975',
      NULL,
      21.801934,
      NULL,
      8,
      35,
      54,
      0,
      ' 0- 6-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7- 0-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-18-1998',
      1.922429,
      NULL,
      NULL,
      NULL,
      ' 8-26-1993',
      41.269399,
      NULL,
      ' 8-22-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      15.883491,
      ' 1- 8-2002',
      66.627800,
      NULL,
      22,
      ' 0-19-1975',
      NULL,
      128,
      ' 0- 8-1987',
      9.876654,
      NULL,
      NULL,
      70,
      ' 4- 0-1998',
      41,
      0,
      24,
      ' 6- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


