set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '2',
      '2',
      NULL,
      '1',
      '4',
      NULL,
      '4',
      '0',
      '3',
      '2',
      '1',
      '0',
      '1',
      '2',
      '1',
      '2',
      '2',
      '2',
      '',
      NULL,
      '',
      '4',
      '0',
      '0',
      '3',
      '0',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      '0',
      '012',
      '23221123',
      17.477097,
      3.066895,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '333100',
      4.598085,
      NULL,
      ' 4-10-1992',
      105.592909,
      230.767923,
      12,
      13.324087,
      17.053265,
      14,
      NULL,
      0,
      29,
      7,
      NULL,
      17,
      32.022320,
      12,
      14,
      0.409996,
      2.620739,
      5,
      23.494848,
      24.665066,
      41,
      13.298705,
      101.222395,
      NULL,
      0,
      99,
      31,
      29,
      117.257121,
      205,
      185.543941,
      NULL,
      5,
      19.254277,
      21.448556,
      34,
      6,
      18.965141,
      '11- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      32,
      NULL,
      2.733581,
      NULL,
      3.804048,
      ' 0-22-1998',
      1.684780,
      1.948459,
      211.942249,
      NULL,
      0,
      135,
      1.089204,
      7.587719,
      76.059918,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1990',
      96.399671,
      57,
      NULL,
      NULL,
      51,
      19.819716,
      NULL,
      107,
      47,
      49.976934,
      NULL,
      62,
      ' 5-19-1990',
      26,
      22,
      22,
      NULL,
      56.132998,
      20.109427,
      0,
      ' 8-23-1990',
      21.585005,
      24,
      NULL,
      4.384051,
      3.900133,
      3,
      15,
      4,
      6,
      NULL,
      6.759675,
      0.815633,
      98,
      NULL,
      NULL,
      4,
      24,
      0.756103,
      1.398249,
      0.672223,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.095965,
      ' 0-29-2000',
      41,
      ' 6-18-1995',
      8.811484,
      NULL,
      '11-24-1985',
      65.688073,
      84.594374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      ' 0- 2-1996',
      NULL,
      44.792714,
      3,
      ' 2- 3-2003',
      NULL,
      45.456586,
      ' 5- 8-1976',
      8,
      33.501869,
      NULL,
      26,
      '11-26-1975',
      10,
      1.793142,
      125.650185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


