set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '3',
      '2',
      '0',
      '2',
      '4',
      '0',
      '4',
      '3',
      '4',
      '0',
      NULL,
      '0',
      '3',
      '1',
      '1',
      '0',
      '1',
      '4',
      '4',
      '3',
      '0',
      '0',
      '',
      '3',
      '',
      '4',
      '1',
      '3',
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      '2',
      NULL,
      '0',
      '4',
      '1',
      '0',
      '3',
      '4',
      '342',
      '13232212',
      44,
      23,
      '3000322',
      2,
      NULL,
      3,
      NULL,
      '131324',
      NULL,
      ' 1-22-1989',
      NULL,
      55,
      33.432150,
      43,
      5,
      10.099011,
      6,
      2.033363,
      10.979844,
      4.835004,
      7.381179,
      0,
      19.202073,
      14,
      6,
      21.119842,
      5.288493,
      7.525535,
      14,
      15.544635,
      11.849726,
      NULL,
      5.473568,
      36,
      NULL,
      0,
      90.434022,
      91,
      NULL,
      190.853834,
      1.551033,
      156.658738,
      ' 2-16-1976',
      31.343577,
      NULL,
      18.818412,
      24,
      NULL,
      122,
      ' 2-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      7.283303,
      17.295528,
      19.205194,
      6.594032,
      NULL,
      1,
      1,
      205,
      1.833603,
      NULL,
      184.111582,
      NULL,
      6.719942,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1992',
      70,
      47.425884,
      77,
      20.311176,
      26,
      NULL,
      91.660264,
      29.864915,
      38,
      71.392519,
      NULL,
      NULL,
      ' 2-19-1990',
      30,
      15,
      12,
      4.406324,
      38,
      50,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      20.034289,
      4.969239,
      20.446199,
      15.535871,
      9.396014,
      0,
      14,
      NULL,
      87.651734,
      5.387195,
      0.616238,
      5,
      0.865230,
      0.989522,
      3,
      3,
      0,
      ' 9-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.279126,
      ' 8-22-1995',
      NULL,
      NULL,
      NULL,
      37,
      ' 7-17-1987',
      12.027605,
      ' 7- 0-1978',
      1,
      4,
      ' 0- 6-1982',
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      13,
      ' 6-14-2003',
      58.768360,
      0,
      30.488587,
      '10-10-1986',
      0,
      20.355522,
      ' 0- 3-1992',
      NULL,
      22,
      3,
      39.673058,
      NULL,
      63,
      1,
      43,
      ' 5-19-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


