set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7501249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0330',
      NULL,
      '21134321',
      '03344100',
      '00102212',
      '44100020',
      '44303113',
      '01134040',
      '40332104',
      '33423400',
      '30304123',
      '31002013',
      '00104143',
      '21010302',
      '20314033',
      NULL,
      '30330231',
      NULL,
      NULL,
      '02314004',
      NULL,
      '10421031',
      '41210014',
      '12341022',
      '24034120',
      '11440042',
      '13140042',
      '14441401',
      '24213214',
      '00003343',
      NULL,
      '24441140',
      '02122123',
      NULL,
      NULL,
      '04423300',
      '30040203',
      NULL,
      NULL,
      '33422422',
      '43204214',
      '21300040',
      '42340421',
      '41322121',
      '04144124',
      NULL,
      '30',
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      5,
      ' 8-17-1974',
      ' 7- 7-1977',
      71,
      NULL,
      20,
      NULL,
      15.545865,
      16.918174,
      NULL,
      6.110158,
      NULL,
      3,
      7,
      5.612919,
      9,
      NULL,
      20,
      2.842985,
      10,
      2.220665,
      NULL,
      12.667955,
      7.473573,
      11.777973,
      70.955893,
      NULL,
      0.832680,
      28,
      98.612124,
      10.332775,
      48,
      24.152685,
      NULL,
      ' 7-21-1982',
      3.931606,
      7,
      NULL,
      9,
      56.545945,
      41.133774,
      NULL,
      0.822104,
      0,
      1.660548,
      2.825886,
      NULL,
      0,
      14,
      NULL,
      0,
      1,
      1.279674,
      1,
      2,
      3,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 6-1996',
      23.043124,
      16.321989,
      2.791683,
      NULL,
      2,
      NULL,
      '11- 9-1975',
      NULL,
      0.116487,
      NULL,
      2.067751,
      1.192542,
      95,
      0.163884,
      NULL,
      22.394155,
      NULL,
      NULL,
      NULL,
      '11-11-1974',
      41,
      67,
      29,
      86.451762,
      5,
      6,
      50,
      49.023258,
      29.202598,
      88.815598,
      9.933785,
      15.609823,
      ' 7-19-1996',
      14.341492,
      NULL,
      NULL,
      1,
      NULL,
      2,
      5.493753,
      ' 3-17-1988',
      NULL,
      19.586766,
      '11- 6-1983',
      12,
      11,
      0.561660,
      6.263388,
      15.918128,
      3,
      1,
      16.171433,
      0.142437,
      95.491934,
      1.608218,
      3.097313,
      11,
      22.383434,
      3,
      1,
      1.506377,
      1.106778,
      ' 0-21-1988',
      0.937354,
      0.745210,
      0,
      ' 5-28-1995',
      30.961627,
      2.136458,
      ' 2-17-1995',
      NULL,
      NULL,
      NULL,
      12.963246,
      NULL,
      9,
      '11-24-1994',
      9,
      7,
      ' 2-16-1993',
      77.348035,
      42.505186,
      ' 1-19-1997',
      2,
      7,
      '10- 9-1987',
      1.281957,
      8.826775,
      ' 7- 3-1977',
      0,
      2,
      2.619602,
      ' 8- 2-1988',
      NULL,
      NULL,
      10,
      NULL,
      1.002875,
      4,
      ' 9-24-1977',
      5.244863,
      22,
      7.512160,
      16,
      ' 1-28-1988',
      43.040750,
      1.796378,
      189,
      ' 9-22-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.145241);
commit;
end;
/


