set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2110',
      '31004441',
      '10322332',
      '40313031',
      NULL,
      '22002332',
      '03244132',
      NULL,
      NULL,
      '41432331',
      '32121231',
      '21114024',
      '41240441',
      '44431312',
      '01201204',
      '13303320',
      '02421243',
      '14434120',
      '22210303',
      '22021223',
      NULL,
      '22203131',
      '40031110',
      '21403020',
      NULL,
      '14410100',
      '01323420',
      '31341142',
      NULL,
      '40411020',
      '11210133',
      '21112223',
      '44011034',
      '40202240',
      '03133422',
      NULL,
      NULL,
      '44241221',
      NULL,
      '44044313',
      NULL,
      '04143330',
      '20032424',
      '40333314',
      '33101343',
      '',
      '',
      NULL,
      NULL,
      '4032432',
      0,
      0.426593,
      3,
      NULL,
      '443122',
      2,
      ' 9-15-1976',
      NULL,
      68.914336,
      NULL,
      14,
      11,
      9.757148,
      4.276324,
      3,
      5,
      1,
      NULL,
      NULL,
      1,
      17,
      8.815864,
      NULL,
      7,
      NULL,
      7.077674,
      2.135255,
      7,
      7.365313,
      1.600144,
      58,
      NULL,
      NULL,
      2,
      62.641219,
      27.967692,
      NULL,
      67.689808,
      69.895147,
      ' 2-14-1986',
      NULL,
      6.540745,
      NULL,
      1,
      135,
      119,
      ' 2-23-1975',
      NULL,
      1.602985,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779266,
      4.911602,
      NULL,
      NULL,
      6.368986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-13-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-29-1980',
      67,
      58.987130,
      52,
      80.205890,
      15,
      13.901568,
      83,
      11.823984,
      18.634047,
      21,
      88,
      86.146992,
      ' 7- 2-1990',
      2,
      8.778364,
      7,
      18,
      19.951280,
      11.141083,
      1.961623,
      NULL,
      0.176478,
      1,
      '11- 1-1997',
      12,
      16.129796,
      12,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      17.462395,
      3,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      14.129840,
      ' 1- 9-1977',
      NULL,
      NULL,
      ' 4-27-1977',
      10.523838,
      30,
      9,
      61.916265,
      ' 1-11-1978',
      NULL,
      1.176861,
      97,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      51.358425,
      NULL,
      NULL,
      NULL,
      141.750003,
      211,
      1,
      40,
      NULL,
      NULL,
      0,
      0.448434,
      32,
      0.422617,
      1.578740,
      20.587102,
      NULL,
      1,
      87,
      0,
      0,
      198.532207,
      NULL,
      7.409190,
      NULL,
      1.488941,
      NULL,
      0.991426,
      0,
      1.603437,
      NULL,
      1.186277,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.638901,
      1,
      0.436996,
      NULL,
      1.536370,
      NULL,
      8.379704,
      NULL,
      1,
      1.809326,
      NULL,
      26,
      8,
      NULL,
      NULL,
      NULL,
      9.356549,
      NULL,
      7.652766,
      7.044707,
      1,
      6.885175,
      3.422214,
      2,
      0.724314,
      1.075933,
      NULL,
      NULL,
      ' 5- 9-1987',
      ' 5- 8-1980',
      ' 7-16-1985',
      ' 9-11-1999',
      ' 0-27-1981',
      NULL,
      NULL);
commit;
end;
/


