set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8904329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '34201434',
      '01340142',
      '34323032',
      '01013304',
      '22331103',
      NULL,
      '33221110',
      NULL,
      '11144200',
      '11101232',
      NULL,
      NULL,
      NULL,
      '41012144',
      '32330234',
      '10131001',
      '04223021',
      '03244333',
      '04224113',
      '14223031',
      '41133423',
      '30203002',
      '24341231',
      '42321302',
      '13123400',
      '20002201',
      '00134440',
      '03232203',
      '32143302',
      '34144123',
      '02320240',
      '02402430',
      '10420444',
      '43331142',
      '14141003',
      '13204112',
      '00120042',
      '30004143',
      '30022133',
      '22242431',
      '11423333',
      '40011012',
      '04412143',
      '41243143',
      '',
      '',
      NULL,
      NULL,
      '1121112',
      NULL,
      0,
      2,
      NULL,
      '314133',
      NULL,
      ' 9-14-1987',
      ' 6- 5-1996',
      16.589228,
      NULL,
      4.563858,
      2,
      31.288605,
      16.456397,
      11.419494,
      11,
      16,
      19,
      44.915732,
      10.573135,
      31.734395,
      NULL,
      2,
      8,
      NULL,
      NULL,
      7.744172,
      9.015696,
      2.912883,
      13.377482,
      29.080885,
      0.323161,
      NULL,
      4,
      93,
      NULL,
      44.861236,
      NULL,
      139.546561,
      ' 3-13-1990',
      NULL,
      NULL,
      NULL,
      9,
      119,
      21.428255,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993672,
      1,
      0.463370,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 4-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1980',
      107,
      6,
      87.720525,
      37,
      NULL,
      60.079373,
      32.157039,
      31,
      NULL,
      94,
      7.592774,
      0.544087,
      ' 5-15-1984',
      13.754192,
      2.118399,
      3,
      26,
      14,
      18,
      5,
      ' 9- 1-1993',
      1.165275,
      0.116955,
      ' 6-10-1981',
      NULL,
      9.087101,
      11.784174,
      9.111039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.657748,
      1.386121,
      2.039693,
      1.831573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.843030,
      NULL,
      15.039231,
      ' 4-15-1988',
      0.262714,
      146,
      NULL,
      NULL,
      NULL,
      NULL,
      27.273734,
      NULL,
      18.247091,
      1,
      137.544430,
      ' 3-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      0.831290,
      39.336425,
      20,
      70.335957,
      13,
      2,
      0,
      NULL,
      3,
      NULL,
      0,
      1.284353,
      35.321878,
      0.418309,
      0,
      54.367840,
      NULL,
      1.545092,
      2,
      NULL,
      3.707629,
      24.726064,
      17,
      28,
      18.141528,
      3.476957,
      18.803847,
      1,
      NULL,
      1,
      0.353283,
      1.727852,
      0,
      34.076467,
      0,
      33.676398,
      18.632455,
      30.927239,
      21.277684,
      1.620457,
      8.920804,
      74.447358,
      2.158283,
      0,
      NULL,
      71,
      1.418491,
      41.421717,
      6.577959,
      35,
      NULL,
      NULL,
      4.250240,
      24.080507,
      0.449044,
      30.119468,
      13.082674,
      6.249207,
      17,
      24.674517,
      NULL,
      7.915931,
      NULL,
      9.972201,
      0,
      1.364578,
      2.153940,
      0,
      23.774340,
      ' 8-12-1980',
      ' 3- 5-1984',
      ' 0-29-1997',
      '11- 0-1979',
      ' 8-24-1979',
      ' 9-11-1976',
      '11-19-1984',
      NULL);
commit;
end;
/


