set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6916210';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2033',
      '30044432',
      '14233432',
      '23431202',
      NULL,
      '40443234',
      '43030211',
      '21403312',
      '31423430',
      NULL,
      '03343004',
      '32102401',
      NULL,
      '00003121',
      '14133141',
      '04414224',
      '41104010',
      '41313344',
      '10433401',
      '22101410',
      NULL,
      '41112014',
      '13130003',
      '14033122',
      '40301000',
      NULL,
      '40010311',
      '10041041',
      '00322442',
      '22224332',
      '00023342',
      NULL,
      '32332404',
      '34200313',
      '23244104',
      '31242231',
      '41004332',
      '11243112',
      NULL,
      '03440442',
      '34032343',
      NULL,
      '44013043',
      '23200440',
      '21030403',
      NULL,
      NULL,
      NULL,
      NULL,
      '4140331',
      0.743490,
      0.972443,
      0,
      NULL,
      '412434',
      NULL,
      ' 4-26-1979',
      NULL,
      35.998694,
      NULL,
      21,
      7,
      15,
      2,
      105.356121,
      16,
      3,
      24.773192,
      NULL,
      NULL,
      34.431154,
      20.654168,
      29.728255,
      1,
      4.215368,
      18.871489,
      11,
      15,
      NULL,
      4.060138,
      NULL,
      9,
      1.178988,
      74.320376,
      NULL,
      105.480335,
      74.954309,
      125,
      98.650109,
      ' 9- 1-1984',
      59.644499,
      NULL,
      20.954392,
      0.871381,
      47,
      NULL,
      '10-22-1976',
      0,
      0.569556,
      0.826008,
      2,
      0.887463,
      0.847354,
      1.573708,
      NULL,
      1,
      1,
      1,
      0,
      0.825118,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.039651,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 9-1986',
      23.592823,
      17,
      NULL,
      6.331866,
      4,
      NULL,
      ' 7-12-1998',
      NULL,
      0.462945,
      181,
      0.348440,
      NULL,
      NULL,
      1,
      0.041595,
      3,
      NULL,
      0.573595,
      33,
      '10-10-1974',
      86,
      80.333907,
      NULL,
      NULL,
      46,
      9,
      57.491861,
      84,
      58.999057,
      NULL,
      49.970034,
      29.909226,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      56.835544,
      NULL,
      7,
      '10-27-1978',
      NULL,
      25.368170,
      ' 5-28-1977',
      0,
      2.832769,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      17,
      1,
      25.550419,
      3,
      7.608414,
      2,
      16.511646,
      0,
      0.953075,
      NULL,
      0.278912,
      NULL,
      NULL,
      7.022844,
      8,
      NULL,
      113.016762,
      8.868690,
      ' 4- 5-1995',
      12,
      13,
      ' 5-20-1998',
      3.004302,
      ' 0- 3-2001',
      NULL,
      '10- 4-1978',
      0,
      2,
      '11-13-1995',
      45.772374,
      57,
      '10-22-1995',
      12,
      15,
      ' 7- 0-2000',
      6,
      1,
      ' 6-16-1999',
      2,
      1,
      22.378088,
      ' 8-12-1983',
      68.327165,
      NULL,
      28.523505,
      ' 3-20-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.631565);
commit;
end;
/


