set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9017167';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1122',
      '34313322',
      '10022333',
      '23102213',
      '22310230',
      '42114110',
      NULL,
      '32120420',
      '01012222',
      '13404111',
      '23020402',
      '41114001',
      '44221214',
      NULL,
      '04312404',
      '22010000',
      '32221210',
      '23111340',
      '01202002',
      '20043341',
      '14342141',
      '31144341',
      '02230424',
      '00223322',
      '43410410',
      '14131140',
      '01324311',
      '44233430',
      '20021340',
      NULL,
      '32402023',
      '13403102',
      '43442341',
      '03311420',
      '12000222',
      '00340034',
      '11104204',
      '12132442',
      NULL,
      '14121122',
      '22441402',
      '40134101',
      '12432021',
      '13423412',
      '34303140',
      '',
      '',
      NULL,
      NULL,
      '1023110',
      1.664778,
      NULL,
      2,
      NULL,
      '230021',
      0.808941,
      ' 7- 5-1979',
      ' 0-20-2003',
      38.676850,
      NULL,
      32,
      14,
      6,
      NULL,
      NULL,
      7.658629,
      4.243101,
      12,
      9.270564,
      NULL,
      NULL,
      27,
      25.131674,
      9.083892,
      13,
      NULL,
      36,
      NULL,
      25,
      NULL,
      17,
      2,
      NULL,
      87.306420,
      202.925384,
      23.964480,
      29.449776,
      140.003960,
      25,
      '11- 0-1991',
      27.719590,
      NULL,
      NULL,
      8.604275,
      89.469945,
      55.869040,
      ' 4-15-1993',
      2.946906,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705027,
      0.480240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      0.783912,
      17.386083,
      2,
      58,
      22,
      NULL,
      ' 9- 7-1981',
      NULL,
      NULL,
      NULL,
      15,
      4.667050,
      1,
      18,
      28.989843,
      11.830125,
      NULL,
      9,
      NULL,
      107.816471,
      1.488588,
      1.835255,
      2.520698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      6.606153,
      8,
      NULL,
      0,
      176.523767,
      ' 5-11-1979',
      NULL,
      25,
      4.412722,
      38,
      '11-17-1993',
      NULL,
      1,
      89.994339,
      ' 0-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      1,
      NULL,
      0,
      1.243083,
      1,
      0.397527,
      1.291309,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.112130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1993',
      ' 2- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


