set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312569';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1042',
      '23014303',
      NULL,
      '11144002',
      '10003031',
      '42320213',
      '12422130',
      '44334044',
      '01434114',
      '31231202',
      NULL,
      '21334000',
      '13434413',
      '24433331',
      '21001130',
      '14444202',
      NULL,
      '14112224',
      '24303014',
      NULL,
      '40124344',
      '32443342',
      NULL,
      '30040402',
      '10210324',
      '43000224',
      '43011343',
      '00243131',
      '04241303',
      '24020212',
      '04321400',
      '42023411',
      '13330043',
      '00404312',
      '30330200',
      '20013021',
      '02102041',
      '13013100',
      '10204302',
      '32323400',
      '42414111',
      '03004440',
      NULL,
      '32401242',
      '33403232',
      '420',
      '04',
      NULL,
      NULL,
      '0134000',
      NULL,
      1.615641,
      0,
      NULL,
      '212213',
      2.877108,
      ' 9-29-1982',
      ' 7- 1-1991',
      4.193704,
      NULL,
      13.390456,
      10.492231,
      22.808835,
      9,
      56,
      13,
      25,
      2,
      0.544847,
      6.050116,
      20,
      12.687524,
      26,
      17,
      NULL,
      8,
      56,
      26,
      60.303794,
      3,
      NULL,
      3,
      0,
      91.563878,
      NULL,
      6,
      270.235714,
      186,
      192.130719,
      ' 3- 3-1988',
      NULL,
      NULL,
      18,
      14.071845,
      NULL,
      93.930177,
      NULL,
      0,
      3.073536,
      NULL,
      NULL,
      0.696496,
      NULL,
      4,
      NULL,
      0,
      0,
      1.022021,
      1,
      0,
      2.420413,
      1.971269,
      1.532541,
      NULL,
      NULL,
      0.799453,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-2000',
      NULL,
      13.173139,
      NULL,
      6.668869,
      5,
      1,
      ' 5-22-1978',
      NULL,
      1,
      99.696825,
      0.351702,
      0,
      134,
      0.777183,
      0.410172,
      70,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1975',
      88,
      81.905771,
      53.137465,
      40,
      5,
      109,
      37,
      44.926581,
      55.760330,
      51,
      89,
      105.474355,
      '11-14-1975',
      3,
      24,
      9,
      55.693905,
      26,
      34.144548,
      6,
      ' 3- 8-1995',
      11,
      2.221817,
      NULL,
      15,
      3,
      NULL,
      6.526983,
      20.465151,
      8.170236,
      1,
      13,
      NULL,
      79.310987,
      1,
      0.600989,
      16,
      NULL,
      0.162229,
      0.879854,
      0.799613,
      1.100530,
      ' 5- 6-1982',
      8.414784,
      2.719861,
      3.873929,
      NULL,
      158,
      9,
      ' 4- 2-1980',
      23.176019,
      NULL,
      NULL,
      42,
      ' 1-19-1984',
      30.920900,
      ' 6- 5-1988',
      8,
      11.348734,
      NULL,
      13,
      96,
      ' 7-11-1975',
      10,
      4.590076,
      ' 2-26-2002',
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 0- 9-1991',
      25,
      NULL,
      NULL,
      ' 7- 4-1986',
      1,
      23,
      ' 2- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.268181);
commit;
end;
/


