set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31444130',
      '43213012',
      '10222244',
      NULL,
      '40111333',
      NULL,
      '13011042',
      '42104124',
      '13341200',
      '24320120',
      '02233421',
      '01222104',
      '40241430',
      '13101020',
      NULL,
      NULL,
      '30043314',
      '12030422',
      '44420002',
      '02332224',
      '41030130',
      '33212112',
      '11041300',
      '01014102',
      '30310214',
      NULL,
      NULL,
      '43141204',
      NULL,
      '33113220',
      '32111444',
      '34440143',
      '33330101',
      '43002421',
      '31130420',
      '00041322',
      '12212342',
      '10221401',
      '21022121',
      '24411444',
      '20041321',
      NULL,
      '23300323',
      '34340140',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.676969,
      1,
      NULL,
      NULL,
      NULL,
      '10-11-1984',
      ' 1-27-1992',
      18.624329,
      NULL,
      NULL,
      7.116871,
      11.490822,
      9,
      NULL,
      6.859879,
      5.845573,
      NULL,
      NULL,
      11.957843,
      2,
      5.140786,
      0,
      1.902220,
      17.463846,
      2.299543,
      NULL,
      6,
      9.329671,
      16.205985,
      43,
      5,
      NULL,
      35,
      127,
      25.094343,
      98,
      NULL,
      78,
      ' 8-27-1983',
      14,
      5.552208,
      NULL,
      NULL,
      145.069437,
      118,
      ' 4- 1-1981',
      1,
      0,
      8,
      0.814168,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278778,
      0,
      0.770110,
      1,
      1.054943,
      0.692574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1978',
      114,
      19.754478,
      90.540754,
      NULL,
      108,
      53,
      136,
      NULL,
      NULL,
      36,
      NULL,
      NULL,
      ' 8-11-1990',
      NULL,
      16,
      2.223516,
      24,
      4,
      21.773990,
      9.494267,
      ' 3-28-2003',
      4,
      NULL,
      ' 2-24-1978',
      0,
      3,
      NULL,
      NULL,
      9,
      4.608454,
      NULL,
      0.053766,
      NULL,
      45.410728,
      NULL,
      0,
      0.324299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      15.357596,
      NULL,
      1.358401,
      NULL,
      NULL,
      4.539515,
      NULL,
      5.031514,
      69.662010,
      ' 5- 3-1997',
      60.451027,
      0,
      86.325450,
      ' 4-23-1998',
      NULL,
      NULL,
      NULL,
      107,
      1,
      NULL,
      89.559858,
      51.548271,
      106,
      53,
      9,
      67.270283,
      13.334592,
      7.051076,
      117.665682,
      0.731427,
      3.173906,
      104,
      2,
      4.774740,
      88,
      NULL,
      2,
      230,
      9,
      2.956994,
      143,
      33,
      14.290474,
      NULL,
      0.364630,
      114,
      1.204492,
      1.049312,
      NULL,
      3.513052,
      NULL,
      0,
      5.411170,
      118,
      3.570288,
      2.375482,
      NULL,
      45.729750,
      0.715463,
      0,
      13,
      0.639319,
      NULL,
      1.399021,
      5.855270,
      1.291304,
      125.469108,
      2.697902,
      NULL,
      0,
      0.913529,
      87.527523,
      8.270240,
      NULL,
      5,
      NULL,
      0,
      NULL,
      12,
      NULL,
      7.005919,
      1.591299,
      1.646429,
      1.834675,
      NULL,
      0.312589,
      1.255800,
      35.680284,
      NULL,
      ' 8-23-1981',
      ' 1-19-1996',
      NULL,
      ' 1- 7-1990',
      '10-16-1981',
      ' 3- 6-1995',
      NULL);
commit;
end;
/


