set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2414',
      NULL,
      '21333424',
      NULL,
      NULL,
      '33232010',
      NULL,
      '12231300',
      NULL,
      NULL,
      '42024202',
      '41040014',
      '02320320',
      '20400312',
      '43314224',
      '24201031',
      '44131203',
      '30201023',
      '41131044',
      '20020001',
      '24203244',
      '44323123',
      '11104402',
      NULL,
      '04031101',
      '13404204',
      '43430001',
      '40444433',
      '14211101',
      '43443414',
      '23143121',
      '23204414',
      '40143204',
      '13040423',
      '44221243',
      '34123030',
      NULL,
      '14211403',
      '03223033',
      NULL,
      '30002303',
      '13232424',
      '13123110',
      '40230341',
      NULL,
      '403',
      '20',
      NULL,
      NULL,
      '0222232',
      3,
      32.758593,
      0,
      NULL,
      '142242',
      2.001822,
      ' 2-12-1980',
      ' 6-24-1989',
      NULL,
      NULL,
      12.470960,
      3.106455,
      15,
      0,
      12,
      0.852475,
      12,
      10,
      0,
      8,
      1.849015,
      2.860560,
      NULL,
      5,
      10.347219,
      6,
      67,
      13,
      36.062956,
      13.146033,
      17.826335,
      10,
      2,
      15,
      56,
      NULL,
      171,
      95.685235,
      52,
      ' 5-15-2000',
      1.827571,
      2,
      NULL,
      13,
      39,
      89,
      ' 9-21-1999',
      1,
      4.608049,
      5.696562,
      NULL,
      1.834465,
      0,
      7.257763,
      1.263763,
      0.243066,
      0.786193,
      3,
      1,
      1.474835,
      NULL,
      1,
      0,
      3.398586,
      0.499590,
      1.651422,
      1.132474,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1974',
      34,
      0.628687,
      NULL,
      1,
      NULL,
      NULL,
      ' 0-19-2001',
      0,
      0.595938,
      NULL,
      1,
      3,
      26,
      1.600482,
      2,
      52.002078,
      NULL,
      NULL,
      NULL,
      NULL,
      142.669304,
      NULL,
      33,
      45,
      83,
      NULL,
      30,
      NULL,
      19.942619,
      NULL,
      51,
      2,
      '11-11-1975',
      10,
      NULL,
      11.763522,
      42,
      NULL,
      38,
      11,
      NULL,
      2,
      2,
      NULL,
      1.237273,
      13,
      0.266421,
      5.493137,
      7.367562,
      1.222364,
      NULL,
      12,
      NULL,
      37,
      0.827529,
      NULL,
      6.526009,
      12,
      3.101760,
      NULL,
      1.385058,
      0.908681,
      ' 6-26-1998',
      1.948904,
      1.214575,
      3.619868,
      ' 1-10-1991',
      113.638626,
      4.582049,
      ' 0-22-1987',
      NULL,
      NULL,
      NULL,
      7.197450,
      ' 8- 4-1998',
      30.826840,
      ' 6- 6-1984',
      6,
      0.210727,
      ' 8-16-1978',
      NULL,
      36,
      ' 0-18-1992',
      NULL,
      3,
      ' 1-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.048032,
      NULL,
      66,
      NULL,
      9.311494,
      ' 6-10-1975',
      3.644285,
      3.814002,
      ' 3-10-2003',
      1,
      NULL,
      NULL,
      20.888334,
      ' 1- 6-2003',
      10.727547,
      0,
      NULL,
      ' 9-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975156);
commit;
end;
/


