set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1320',
      '03431234',
      NULL,
      '21333123',
      '32223223',
      '14331434',
      '23021132',
      '01410303',
      NULL,
      NULL,
      '30403433',
      '04201012',
      '32011230',
      '20200022',
      '10232304',
      NULL,
      '41143244',
      '03440034',
      '44200112',
      '44134440',
      NULL,
      '03334104',
      '32014004',
      NULL,
      '41204334',
      '33331313',
      NULL,
      '34121224',
      '44032211',
      '21010244',
      NULL,
      NULL,
      '32110342',
      '24013224',
      '21333414',
      '34242200',
      '40042243',
      '24404113',
      '13310040',
      NULL,
      '32202030',
      NULL,
      NULL,
      NULL,
      '30021322',
      '123',
      NULL,
      NULL,
      4,
      '4212402',
      0,
      16,
      3,
      NULL,
      '342140',
      NULL,
      ' 2-27-2002',
      ' 7-18-1998',
      NULL,
      14.746336,
      3,
      9,
      NULL,
      8.708981,
      17,
      10,
      9.979961,
      8,
      NULL,
      3.901324,
      21.359208,
      7,
      2.369394,
      0.263269,
      5,
      3,
      24.831708,
      NULL,
      7,
      18,
      18,
      7.078767,
      0.987525,
      13,
      NULL,
      44,
      17,
      NULL,
      NULL,
      ' 7- 7-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      23,
      26.206286,
      16,
      NULL,
      3.431259,
      NULL,
      0.650692,
      NULL,
      61,
      0,
      NULL,
      19,
      NULL,
      0,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      13,
      33.654383,
      40,
      35,
      40.883786,
      75.451640,
      41,
      13,
      38,
      28.608418,
      ' 6-26-2002',
      4.542072,
      5.475313,
      5.704131,
      18,
      13,
      16.402931,
      5.606667,
      ' 7-13-1984',
      11,
      5,
      NULL,
      2,
      13.655304,
      NULL,
      1,
      7,
      6,
      NULL,
      NULL,
      1.048737,
      NULL,
      0,
      NULL,
      4,
      9,
      2,
      1.750128,
      1.239975,
      1,
      ' 5- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      3,
      '11- 4-1997',
      NULL,
      NULL,
      NULL,
      24.300822,
      ' 8-12-1986',
      28,
      ' 6- 6-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      ' 2-17-1999',
      29.666807,
      28.033039,
      21,
      ' 1-28-2001',
      NULL,
      498,
      ' 8-10-1976',
      NULL,
      NULL,
      5,
      30.699942,
      '11-24-1981',
      61.790427,
      0,
      71.947795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


